/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.git.RenameGroupOp;
import com.google.gerrit.server.group.Groups;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jgit.lib.PersonIdent;

public class GroupsUpdate {
    private final Groups groups;
    private final GroupCache groupCache;
    private final GroupIncludeCache groupIncludeCache;
    private final AuditService auditService;
    private final RenameGroupOp.Factory renameGroupOpFactory;
    @Nullable
    private final IdentifiedUser currentUser;
    private final PersonIdent committerIdent;

    @Inject
    GroupsUpdate(Groups groups, GroupCache groupCache, GroupIncludeCache groupIncludeCache, AuditService auditService, RenameGroupOp.Factory renameGroupOpFactory, @GerritPersonIdent PersonIdent serverIdent, @Assisted @Nullable IdentifiedUser currentUser) {
        this.groups = groups;
        this.groupCache = groupCache;
        this.groupIncludeCache = groupIncludeCache;
        this.auditService = auditService;
        this.renameGroupOpFactory = renameGroupOpFactory;
        this.currentUser = currentUser;
        this.committerIdent = GroupsUpdate.getCommitterIdent(serverIdent, currentUser);
    }

    private static PersonIdent getCommitterIdent(PersonIdent serverIdent, @Nullable IdentifiedUser currentUser) {
        return currentUser != null ? GroupsUpdate.createPersonIdent(serverIdent, currentUser) : serverIdent;
    }

    private static PersonIdent createPersonIdent(PersonIdent ident, IdentifiedUser user) {
        return user.newCommitterIdent(ident.getWhen(), ident.getTimeZone());
    }

    public void addGroup(ReviewDb db, AccountGroup group, Set<Account.Id> memberIds) throws OrmException, IOException {
        GroupsUpdate.addNewGroup(db, group);
        this.addNewGroupMembers(db, group, memberIds);
        this.groupCache.onCreateGroup(group);
    }

    public static void addNewGroup(ReviewDb db, AccountGroup group) throws OrmException {
        AccountGroupName gn = new AccountGroupName(group);
        db.accountGroupNames().insert(ImmutableList.of(gn));
        db.accountGroups().insert(ImmutableList.of(group));
    }

    public void updateGroup(ReviewDb db, AccountGroup.UUID groupUuid, Consumer<AccountGroup> groupConsumer) throws OrmException, IOException, NoSuchGroupException {
        AccountGroup updatedGroup = this.updateGroupInDb(db, groupUuid, groupConsumer);
        this.groupCache.evict(updatedGroup.getGroupUUID(), updatedGroup.getId(), updatedGroup.getNameKey());
    }

    @VisibleForTesting
    public AccountGroup updateGroupInDb(ReviewDb db, AccountGroup.UUID groupUuid, Consumer<AccountGroup> groupConsumer) throws OrmException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        groupConsumer.accept(group);
        db.accountGroups().update(ImmutableList.of(group));
        return group;
    }

    public void renameGroup(ReviewDb db, AccountGroup.UUID groupUuid, AccountGroup.NameKey newName) throws OrmException, IOException, NameAlreadyUsedException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        AccountGroup.NameKey oldName = group.getNameKey();
        try {
            AccountGroupName id = new AccountGroupName(newName, group.getId());
            db.accountGroupNames().insert(ImmutableList.of(id));
        }
        catch (OrmException e) {
            AccountGroupName other = db.accountGroupNames().get(newName);
            if (other != null) {
                if (other.getId().equals(group.getId())) {
                    return;
                }
                throw new NameAlreadyUsedException("group with name " + newName + " already exists");
            }
            throw e;
        }
        group.setNameKey(newName);
        db.accountGroups().update(ImmutableList.of(group));
        db.accountGroupNames().deleteKeys(ImmutableList.of(oldName));
        this.groupCache.evictAfterRename(oldName);
        this.groupCache.evict(group.getGroupUUID(), group.getId(), group.getNameKey());
        ScheduledFuture<?> possiblyIgnoredError = this.renameGroupOpFactory.create(this.committerIdent, groupUuid, oldName.get(), newName.get()).start(0L, TimeUnit.MILLISECONDS);
    }

    public void addGroupMember(ReviewDb db, AccountGroup.UUID groupUuid, Account.Id accountId) throws OrmException, IOException, NoSuchGroupException {
        this.addGroupMembers(db, groupUuid, ImmutableSet.of(accountId));
    }

    public void addGroupMembers(ReviewDb db, AccountGroup.UUID groupUuid, Set<Account.Id> accountIds) throws OrmException, IOException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        HashSet<Account.Id> newMemberIds = new HashSet<Account.Id>();
        for (Account.Id accountId : accountIds) {
            boolean isMember = this.groups.isMember(db, groupUuid, accountId);
            if (isMember) continue;
            newMemberIds.add(accountId);
        }
        if (newMemberIds.isEmpty()) {
            return;
        }
        this.addNewGroupMembers(db, group, newMemberIds);
    }

    private void addNewGroupMembers(ReviewDb db, AccountGroup group, Set<Account.Id> newMemberIds) throws OrmException, IOException {
        Set newMembers = newMemberIds.stream().map(accountId -> new AccountGroupMember.Key((Account.Id)accountId, group.getId())).map(AccountGroupMember::new).collect(ImmutableSet.toImmutableSet());
        if (this.currentUser != null) {
            this.auditService.dispatchAddAccountsToGroup(this.currentUser.getAccountId(), newMembers);
        }
        db.accountGroupMembers().insert(newMembers);
        this.groupCache.evict(group.getGroupUUID(), group.getId(), group.getNameKey());
        for (AccountGroupMember newMember : newMembers) {
            this.groupIncludeCache.evictGroupsWithMember(newMember.getAccountId());
        }
    }

    public void removeGroupMembers(ReviewDb db, AccountGroup.UUID groupUuid, Set<Account.Id> accountIds) throws OrmException, IOException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        AccountGroup.Id groupId = group.getId();
        HashSet<AccountGroupMember> membersToRemove = new HashSet<AccountGroupMember>();
        for (Account.Id accountId : accountIds) {
            boolean isMember = this.groups.isMember(db, groupUuid, accountId);
            if (!isMember) continue;
            AccountGroupMember.Key key = new AccountGroupMember.Key(accountId, groupId);
            membersToRemove.add(new AccountGroupMember(key));
        }
        if (membersToRemove.isEmpty()) {
            return;
        }
        if (this.currentUser != null) {
            this.auditService.dispatchDeleteAccountsFromGroup(this.currentUser.getAccountId(), membersToRemove);
        }
        db.accountGroupMembers().delete(membersToRemove);
        this.groupCache.evict(group.getGroupUUID(), group.getId(), group.getNameKey());
        for (AccountGroupMember member : membersToRemove) {
            this.groupIncludeCache.evictGroupsWithMember(member.getAccountId());
        }
    }

    public void addSubgroups(ReviewDb db, AccountGroup.UUID parentGroupUuid, Set<AccountGroup.UUID> subgroupUuids) throws OrmException, NoSuchGroupException, IOException {
        AccountGroup parentGroup = Groups.getExistingGroupFromReviewDb(db, parentGroupUuid);
        AccountGroup.Id parentGroupId = parentGroup.getId();
        HashSet<AccountGroupById> newSubgroups = new HashSet<AccountGroupById>();
        for (AccountGroup.UUID includedGroupUuid : subgroupUuids) {
            boolean isSubgroup = this.groups.isSubgroup(db, parentGroupUuid, includedGroupUuid);
            if (isSubgroup) continue;
            AccountGroupById.Key key = new AccountGroupById.Key(parentGroupId, includedGroupUuid);
            newSubgroups.add(new AccountGroupById(key));
        }
        if (newSubgroups.isEmpty()) {
            return;
        }
        if (this.currentUser != null) {
            this.auditService.dispatchAddGroupsToGroup(this.currentUser.getAccountId(), newSubgroups);
        }
        db.accountGroupById().insert(newSubgroups);
        this.groupCache.evict(parentGroup.getGroupUUID(), parentGroup.getId(), parentGroup.getNameKey());
        for (AccountGroupById newIncludedGroup : newSubgroups) {
            this.groupIncludeCache.evictParentGroupsOf(newIncludedGroup.getIncludeUUID());
        }
        this.groupIncludeCache.evictSubgroupsOf(parentGroupUuid);
    }

    public void removeSubgroups(ReviewDb db, AccountGroup.UUID parentGroupUuid, Set<AccountGroup.UUID> subgroupUuids) throws OrmException, NoSuchGroupException, IOException {
        AccountGroup parentGroup = Groups.getExistingGroupFromReviewDb(db, parentGroupUuid);
        AccountGroup.Id parentGroupId = parentGroup.getId();
        HashSet<AccountGroupById> subgroupsToRemove = new HashSet<AccountGroupById>();
        for (AccountGroup.UUID subgroupUuid : subgroupUuids) {
            boolean isSubgroup = this.groups.isSubgroup(db, parentGroupUuid, subgroupUuid);
            if (!isSubgroup) continue;
            AccountGroupById.Key key = new AccountGroupById.Key(parentGroupId, subgroupUuid);
            subgroupsToRemove.add(new AccountGroupById(key));
        }
        if (subgroupsToRemove.isEmpty()) {
            return;
        }
        if (this.currentUser != null) {
            this.auditService.dispatchDeleteGroupsFromGroup(this.currentUser.getAccountId(), subgroupsToRemove);
        }
        db.accountGroupById().delete(subgroupsToRemove);
        this.groupCache.evict(parentGroup.getGroupUUID(), parentGroup.getId(), parentGroup.getNameKey());
        for (AccountGroupById groupToRemove : subgroupsToRemove) {
            this.groupIncludeCache.evictParentGroupsOf(groupToRemove.getIncludeUUID());
        }
        this.groupIncludeCache.evictSubgroupsOf(parentGroupUuid);
    }

    public static interface Factory {
        public GroupsUpdate create(@Nullable IdentifiedUser var1);
    }
}

