/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class PutOwner
implements RestModifyView<GroupResource, Input> {
    private final GroupsCollection groupsCollection;
    private final Provider<GroupsUpdate> groupsUpdateProvider;
    private final Provider<ReviewDb> db;
    private final GroupJson json;

    @Inject
    PutOwner(GroupsCollection groupsCollection, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider, Provider<ReviewDb> db, GroupJson json) {
        this.groupsCollection = groupsCollection;
        this.groupsUpdateProvider = groupsUpdateProvider;
        this.db = db;
        this.json = json;
    }

    public GroupInfo apply(GroupResource resource, Input input) throws ResourceNotFoundException, MethodNotAllowedException, AuthException, BadRequestException, UnprocessableEntityException, OrmException, IOException {
        GroupDescription.Internal internalGroup = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.owner)) {
            throw new BadRequestException("owner is required");
        }
        GroupDescription.Basic owner = this.groupsCollection.parse(input.owner);
        if (!internalGroup.getOwnerGroupUUID().equals(owner.getGroupUUID())) {
            AccountGroup.UUID groupUuid = internalGroup.getGroupUUID();
            try {
                this.groupsUpdateProvider.get().updateGroup(this.db.get(), groupUuid, group -> group.setOwnerGroupUUID(owner.getGroupUUID()));
            }
            catch (NoSuchGroupException e) {
                throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
            }
        }
        return this.json.format(owner);
    }

    public static class Input {
        @DefaultInput
        public String owner;
    }
}

