/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.ChangeBundle;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import java.io.IOException;

public abstract class ChangeRebuilder {
    private final SchemaFactory<ReviewDb> schemaFactory;

    protected ChangeRebuilder(SchemaFactory<ReviewDb> schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public final ListenableFuture<NoteDbUpdateManager.Result> rebuildAsync(Change.Id id, ListeningExecutorService executor) {
        return executor.submit(() -> {
            try (ReviewDb db = this.schemaFactory.open();){
                NoteDbUpdateManager.Result result = this.rebuild(db, id);
                return result;
            }
        });
    }

    public abstract void rebuildReviewDb(ReviewDb var1, Project.NameKey var2, Change.Id var3) throws OrmException;

    public abstract NoteDbUpdateManager.Result rebuild(ReviewDb var1, Change.Id var2) throws IOException, OrmException;

    public abstract NoteDbUpdateManager.Result rebuildEvenIfReadOnly(ReviewDb var1, Change.Id var2) throws IOException, OrmException;

    public abstract NoteDbUpdateManager.Result rebuild(NoteDbUpdateManager var1, ChangeBundle var2) throws IOException, OrmException;

    public abstract void buildUpdates(NoteDbUpdateManager var1, ChangeBundle var2) throws IOException, OrmException;

    public abstract NoteDbUpdateManager stage(ReviewDb var1, Change.Id var2) throws IOException, OrmException;

    public abstract NoteDbUpdateManager.Result execute(ReviewDb var1, Change.Id var2, NoteDbUpdateManager var3) throws OrmException, IOException;

    public static class NoPatchSetsException
    extends OrmException {
        private static final long serialVersionUID = 1L;

        NoPatchSetsException(Change.Id changeId) {
            super("Change " + changeId + " cannot be rebuilt because it has no patch sets");
        }
    }
}

