/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.client.CodedEnum;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ioutil.BasicSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.patch.CombinedFileHeader;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

public class PatchListEntry {
    private static final byte[] EMPTY_HEADER = new byte[0];
    private final Patch.ChangeType changeType;
    private final Patch.PatchType patchType;
    private final String oldName;
    private final String newName;
    private final byte[] header;
    private final ImmutableList<Edit> edits;
    private final ImmutableSet<Edit> editsDueToRebase;
    private final int insertions;
    private final int deletions;
    private final long size;
    private final long sizeDelta;

    static PatchListEntry empty(String fileName) {
        return new PatchListEntry(Patch.ChangeType.MODIFIED, Patch.PatchType.UNIFIED, null, fileName, EMPTY_HEADER, ImmutableList.of(), ImmutableSet.of(), 0, 0, 0L, 0L);
    }

    PatchListEntry(FileHeader hdr, List<Edit> editList, Set<Edit> editsDueToRebase, long size, long sizeDelta) {
        this.changeType = PatchListEntry.toChangeType(hdr);
        this.patchType = PatchListEntry.toPatchType(hdr);
        switch (this.changeType) {
            case DELETED: {
                this.oldName = null;
                this.newName = hdr.getOldPath();
                break;
            }
            case ADDED: 
            case MODIFIED: 
            case REWRITE: {
                this.oldName = null;
                this.newName = hdr.getNewPath();
                break;
            }
            case COPIED: 
            case RENAMED: {
                this.oldName = hdr.getOldPath();
                this.newName = hdr.getNewPath();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + this.changeType);
            }
        }
        this.header = PatchListEntry.compact(hdr);
        this.edits = hdr instanceof CombinedFileHeader || hdr.getHunks().isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(editList);
        this.editsDueToRebase = ImmutableSet.copyOf(editsDueToRebase);
        int ins = 0;
        int del = 0;
        for (Edit e : editList) {
            if (editsDueToRebase.contains(e)) continue;
            del += e.getEndA() - e.getBeginA();
            ins += e.getEndB() - e.getBeginB();
        }
        this.insertions = ins;
        this.deletions = del;
        this.size = size;
        this.sizeDelta = sizeDelta;
    }

    private PatchListEntry(Patch.ChangeType changeType, Patch.PatchType patchType, String oldName, String newName, byte[] header, ImmutableList<Edit> edits, ImmutableSet<Edit> editsDueToRebase, int insertions, int deletions, long size, long sizeDelta) {
        this.changeType = changeType;
        this.patchType = patchType;
        this.oldName = oldName;
        this.newName = newName;
        this.header = header;
        this.edits = edits;
        this.editsDueToRebase = editsDueToRebase;
        this.insertions = insertions;
        this.deletions = deletions;
        this.size = size;
        this.sizeDelta = sizeDelta;
    }

    int weigh() {
        int size = 140;
        size += PatchListEntry.stringSize(this.oldName);
        size += PatchListEntry.stringSize(this.newName);
        size += this.header.length;
        size += 40 * this.edits.size();
        return size += 40 * this.editsDueToRebase.size();
    }

    private static int stringSize(String str) {
        if (str != null) {
            return 44 + str.length() * 2;
        }
        return 0;
    }

    public Patch.ChangeType getChangeType() {
        return this.changeType;
    }

    public Patch.PatchType getPatchType() {
        return this.patchType;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public ImmutableList<Edit> getEdits() {
        return this.edits;
    }

    public ImmutableSet<Edit> getEditsDueToRebase() {
        return this.editsDueToRebase;
    }

    public int getInsertions() {
        return this.insertions;
    }

    public int getDeletions() {
        return this.deletions;
    }

    public long getSize() {
        return this.size;
    }

    public long getSizeDelta() {
        return this.sizeDelta;
    }

    public List<String> getHeaderLines() {
        IntList m = RawParseUtils.lineMap(this.header, 0, this.header.length);
        ArrayList<String> headerLines = new ArrayList<String>(m.size() - 1);
        for (int i = 1; i < m.size() - 1; ++i) {
            int b = m.get(i);
            int e = m.get(i + 1);
            if (this.header[e - 1] == 10) {
                --e;
            }
            headerLines.add(RawParseUtils.decode(Constants.CHARSET, this.header, b, e));
        }
        return headerLines;
    }

    Patch toPatch(PatchSet.Id setId) {
        Patch p = new Patch(new Patch.Key(setId, this.getNewName()));
        p.setChangeType(this.getChangeType());
        p.setPatchType(this.getPatchType());
        p.setSourceFileName(this.getOldName());
        p.setInsertions(this.insertions);
        p.setDeletions(this.deletions);
        return p;
    }

    void writeTo(OutputStream out) throws IOException {
        BasicSerialization.writeEnum(out, this.changeType);
        BasicSerialization.writeEnum(out, this.patchType);
        BasicSerialization.writeString(out, this.oldName);
        BasicSerialization.writeString(out, this.newName);
        BasicSerialization.writeBytes(out, this.header);
        BasicSerialization.writeVarInt32(out, this.insertions);
        BasicSerialization.writeVarInt32(out, this.deletions);
        BasicSerialization.writeFixInt64(out, this.size);
        BasicSerialization.writeFixInt64(out, this.sizeDelta);
        PatchListEntry.writeEditArray(out, this.edits);
        PatchListEntry.writeEditArray(out, this.editsDueToRebase);
    }

    private static void writeEditArray(OutputStream out, Collection<Edit> edits) throws IOException {
        BasicSerialization.writeVarInt32(out, edits.size());
        for (Edit edit : edits) {
            BasicSerialization.writeVarInt32(out, edit.getBeginA());
            BasicSerialization.writeVarInt32(out, edit.getEndA());
            BasicSerialization.writeVarInt32(out, edit.getBeginB());
            BasicSerialization.writeVarInt32(out, edit.getEndB());
        }
    }

    static PatchListEntry readFrom(InputStream in) throws IOException {
        Patch.ChangeType changeType = (Patch.ChangeType)BasicSerialization.readEnum((InputStream)in, (CodedEnum[])Patch.ChangeType.values());
        Patch.PatchType patchType = (Patch.PatchType)BasicSerialization.readEnum((InputStream)in, (CodedEnum[])Patch.PatchType.values());
        String oldName = BasicSerialization.readString(in);
        String newName = BasicSerialization.readString(in);
        byte[] hdr = BasicSerialization.readBytes(in);
        int ins = BasicSerialization.readVarInt32(in);
        int del = BasicSerialization.readVarInt32(in);
        long size = BasicSerialization.readFixInt64(in);
        long sizeDelta = BasicSerialization.readFixInt64(in);
        Edit[] editArray = PatchListEntry.readEditArray(in);
        Edit[] editsDueToRebase = PatchListEntry.readEditArray(in);
        return new PatchListEntry(changeType, patchType, oldName, newName, hdr, ImmutableList.copyOf(editArray), ImmutableSet.copyOf(editsDueToRebase), ins, del, size, sizeDelta);
    }

    private static Edit[] readEditArray(InputStream in) throws IOException {
        int numEdits = BasicSerialization.readVarInt32(in);
        Edit[] edits = new Edit[numEdits];
        for (int i = 0; i < numEdits; ++i) {
            int beginA = BasicSerialization.readVarInt32(in);
            int endA = BasicSerialization.readVarInt32(in);
            int beginB = BasicSerialization.readVarInt32(in);
            int endB = BasicSerialization.readVarInt32(in);
            edits[i] = new Edit(beginA, endA, beginB, endB);
        }
        return edits;
    }

    private static byte[] compact(FileHeader h) {
        int end = PatchListEntry.end(h);
        if (h.getStartOffset() == 0 && end == h.getBuffer().length) {
            return h.getBuffer();
        }
        byte[] buf = new byte[end - h.getStartOffset()];
        System.arraycopy(h.getBuffer(), h.getStartOffset(), buf, 0, buf.length);
        return buf;
    }

    private static int end(FileHeader h) {
        if (h instanceof CombinedFileHeader) {
            return h.getEndOffset();
        }
        if (!h.getHunks().isEmpty()) {
            return h.getHunks().get(0).getStartOffset();
        }
        return h.getEndOffset();
    }

    private static Patch.ChangeType toChangeType(FileHeader hdr) {
        switch (hdr.getChangeType()) {
            case ADD: {
                return Patch.ChangeType.ADDED;
            }
            case MODIFY: {
                return Patch.ChangeType.MODIFIED;
            }
            case DELETE: {
                return Patch.ChangeType.DELETED;
            }
            case RENAME: {
                return Patch.ChangeType.RENAMED;
            }
            case COPY: {
                return Patch.ChangeType.COPIED;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)hdr.getChangeType()));
    }

    private static Patch.PatchType toPatchType(FileHeader hdr) {
        Patch.PatchType pt;
        switch (hdr.getPatchType()) {
            case UNIFIED: {
                pt = Patch.PatchType.UNIFIED;
                break;
            }
            case GIT_BINARY: 
            case BINARY: {
                pt = Patch.PatchType.BINARY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + (Object)((Object)hdr.getPatchType()));
            }
        }
        if (pt != Patch.PatchType.BINARY) {
            byte[] buf = hdr.getBuffer();
            for (int ptr = hdr.getStartOffset(); ptr < hdr.getEndOffset(); ++ptr) {
                if (buf[ptr] != 0) continue;
                pt = Patch.PatchType.BINARY;
                break;
            }
        }
        return pt;
    }
}

