/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.PluginInstallException;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.PrintWriter;
import java.io.StringWriter;

@RequiresCapability(value="administrateServer")
@Singleton
public class ReloadPlugin
implements RestModifyView<PluginResource, Input> {
    private final PluginLoader loader;

    @Inject
    ReloadPlugin(PluginLoader loader) {
        this.loader = loader;
    }

    public PluginInfo apply(PluginResource resource, Input input) throws ResourceConflictException {
        String name = resource.getName();
        try {
            this.loader.reload(ImmutableList.of(name));
        }
        catch (InvalidPluginException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        catch (PluginInstallException e) {
            StringWriter buf = new StringWriter();
            buf.write(String.format("cannot reload %s\n", name));
            PrintWriter pw = new PrintWriter(buf);
            e.printStackTrace(pw);
            pw.flush();
            throw new ResourceConflictException(buf.toString());
        }
        return ListPlugins.toPluginInfo(this.loader.get(name));
    }

    public static class Input {
    }
}

