/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.api.access.ProjectAccessInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.GetAccess;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.SetAccessUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class SetAccess
implements RestModifyView<ProjectResource, ProjectAccessInput> {
    protected final GroupBackend groupBackend;
    private final PermissionBackend permissionBackend;
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final GetAccess getAccess;
    private final ProjectCache projectCache;
    private final Provider<IdentifiedUser> identifiedUser;
    private final SetAccessUtil accessUtil;

    @Inject
    private SetAccess(GroupBackend groupBackend, PermissionBackend permissionBackend, Provider<MetaDataUpdate.User> metaDataUpdateFactory, ProjectCache projectCache, GetAccess getAccess, Provider<IdentifiedUser> identifiedUser, SetAccessUtil accessUtil) {
        this.groupBackend = groupBackend;
        this.permissionBackend = permissionBackend;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.getAccess = getAccess;
        this.projectCache = projectCache;
        this.identifiedUser = identifiedUser;
        this.accessUtil = accessUtil;
    }

    public ProjectAccessInfo apply(ProjectResource rsrc, ProjectAccessInput input) throws ResourceNotFoundException, ResourceConflictException, IOException, AuthException, BadRequestException, UnprocessableEntityException, OrmException, PermissionBackendException {
        MetaDataUpdate.User metaDataUpdateUser = this.metaDataUpdateFactory.get();
        List<AccessSection> removals = this.accessUtil.getAccessSections(input.remove);
        List<AccessSection> additions = this.accessUtil.getAccessSections(input.add);
        try (MetaDataUpdate md = metaDataUpdateUser.create(rsrc.getNameKey());){
            ProjectConfig config = ProjectConfig.read(md);
            boolean checkedAdmin = false;
            for (AccessSection section : Iterables.concat(additions, removals)) {
                boolean isGlobalCapabilities = "GLOBAL_CAPABILITIES".equals(section.getName());
                if (isGlobalCapabilities) {
                    if (checkedAdmin) continue;
                    this.permissionBackend.user(this.identifiedUser).check(GlobalPermission.ADMINISTRATE_SERVER);
                    checkedAdmin = true;
                    continue;
                }
                if (rsrc.getControl().controlForRef(section.getName()).isOwner()) continue;
                throw new AuthException("You are not allowed to edit permissions for ref: " + section.getName());
            }
            this.accessUtil.validateChanges(config, removals, additions);
            this.accessUtil.applyChanges(config, removals, additions);
            this.accessUtil.setParentName(this.identifiedUser.get(), config, rsrc.getNameKey(), input.parent == null ? null : new Project.NameKey(input.parent), !checkedAdmin);
            if (!Strings.isNullOrEmpty(input.message)) {
                if (!input.message.endsWith("\n")) {
                    input.message = input.message + "\n";
                }
                md.setMessage(input.message);
            } else {
                md.setMessage("Modify access rules\n");
            }
            config.commit(md);
            this.projectCache.evict(config.getProject());
        }
        catch (InvalidNameException e) {
            throw new BadRequestException(e.toString());
        }
        catch (ConfigInvalidException e) {
            throw new ResourceConflictException(rsrc.getName());
        }
        return this.getAccess.apply(rsrc.getNameKey());
    }
}

