/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.Config;

public class DB2
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    public DB2(@GerritServerConfig Config cfg) {
        super("com.ibm.db2.jcc.DB2Driver");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbc = new ConfigSection(this.cfg, "database");
        b.append("jdbc:db2://");
        b.append(JdbcUtil.hostname(dbc.optional("hostname")));
        b.append(JdbcUtil.port(dbc.optional("port")));
        b.append("/");
        b.append(dbc.required("database"));
        return b.toString();
    }

    @Override
    public String getValidationQuery() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }
}

