/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.AclUtil;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_125;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_126
extends SchemaVersion {
    private static final String COMMIT_MSG = "Fix default permissions on user branches";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final SystemGroupBackend systemGroupBackend;
    private final PersonIdent serverUser;

    @Inject
    Schema_126(Provider<Schema_125> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, SystemGroupBackend systemGroupBackend, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.systemGroupBackend = systemGroupBackend;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try (Repository git = this.repoManager.openRepository(this.allUsersName);
             MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git);){
            ProjectConfig config = ProjectConfig.read(md);
            String refsUsersShardedId = "refs/users/${shardeduserid}";
            config.remove(config.getAccessSection(refsUsersShardedId));
            GroupReference registered = this.systemGroupBackend.getGroup(SystemGroupBackend.REGISTERED_USERS);
            AccessSection users = config.getAccessSection(refsUsersShardedId, true);
            AclUtil.grant(config, users, "read", false, true, registered);
            AclUtil.grant(config, users, "push", false, true, registered);
            AclUtil.grant(config, users, "submit", false, true, registered);
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            md.setMessage(COMMIT_MSG);
            config.commit(md);
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }
}

