/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.Accounts;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_159;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;

public class Schema_160
extends SchemaVersion {
    @VisibleForTesting
    static final ImmutableList<String> DEFAULT_DRAFT_ITEMS;
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final Provider<PersonIdent> serverIdent;

    @Inject
    Schema_160(Provider<Schema_159> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent Provider<PersonIdent> serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            TextProgressMonitor pm = new TextProgressMonitor();
            pm.beginTask("Removing \"My Drafts\" menu items", 0);
            for (Account.Id id : Accounts.readUserRefs(repo)::iterator) {
                this.removeMyDrafts(repo, RefNames.refsUsers(id), pm);
            }
            this.removeMyDrafts(repo, "refs/users/default", pm);
            pm.endTask();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new OrmException("Removing \"My Drafts\" menu items failed", e);
        }
    }

    private void removeMyDrafts(Repository repo, String ref, ProgressMonitor pm) throws IOException, ConfigInvalidException {
        MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, repo);
        PersonIdent ident = this.serverIdent.get();
        md.getCommitBuilder().setAuthor(ident);
        md.getCommitBuilder().setCommitter(ident);
        Prefs prefs = new Prefs(ref);
        prefs.load(repo);
        prefs.removeMyDrafts();
        prefs.commit(md);
        if (prefs.dirty()) {
            pm.update(1);
        }
    }

    static {
        String ownerSelfIsDraft = "/q/owner:self+is:draft";
        String isDraft = "/q/is:draft";
        DEFAULT_DRAFT_ITEMS = ImmutableList.of(ownerSelfIsDraft, '#' + ownerSelfIsDraft, isDraft, '#' + isDraft);
    }

    private static class Prefs
    extends VersionedAccountPreferences {
        private boolean dirty;

        Prefs(String ref) {
            super(ref);
        }

        @Override
        protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
            if (!this.dirty) {
                return false;
            }
            commit.setMessage("Remove \"My Drafts\" menu items");
            return super.onSave(commit);
        }

        void removeMyDrafts() {
            Config cfg = this.getConfig();
            for (String item : cfg.getSubsections("my")) {
                String value = cfg.getString("my", item, "url");
                if (!DEFAULT_DRAFT_ITEMS.contains(value)) continue;
                cfg.unsetSection("my", item);
                this.dirty = true;
            }
        }

        boolean dirty() {
            return this.dirty;
        }
    }
}

