/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.projects.ConfigValue;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.SuggestParentCandidates;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="createProject")
@CommandMetaData(name="create-project", description="Create a new project and associated Git repository")
final class CreateProjectCommand
extends SshCommand {
    @Option(name="--suggest-parents", aliases={"-S"}, usage="suggest parent candidates, if this option is used all other options and arguments are ignored")
    private boolean suggestParent;
    @Option(name="--owner", aliases={"-o"}, usage="owner(s) of project")
    private List<AccountGroup.UUID> ownerIds;
    @Option(name="--parent", aliases={"-p"}, metaVar="NAME", usage="parent project")
    private ProjectControl newParent;
    @Option(name="--permissions-only", usage="create project for use only as parent")
    private boolean permissionsOnly;
    @Option(name="--description", aliases={"-d"}, metaVar="DESCRIPTION", usage="description of project")
    private String projectDescription = "";
    @Option(name="--submit-type", aliases={"-t"}, usage="project submit type")
    private SubmitType submitType;
    @Option(name="--contributor-agreements", usage="if contributor agreement is required")
    private InheritableBoolean contributorAgreements = InheritableBoolean.INHERIT;
    @Option(name="--signed-off-by", usage="if signed-off-by is required")
    private InheritableBoolean signedOffBy = InheritableBoolean.INHERIT;
    @Option(name="--content-merge", usage="allow automatic conflict resolving within files")
    private InheritableBoolean contentMerge = InheritableBoolean.INHERIT;
    @Option(name="--change-id", usage="if change-id is required")
    private InheritableBoolean requireChangeID = InheritableBoolean.INHERIT;
    @Option(name="--new-change-for-all-not-in-target", usage="if a new change will be created for every commit not in target branch")
    private InheritableBoolean createNewChangeForAllNotInTarget = InheritableBoolean.INHERIT;
    @Option(name="--branch", aliases={"-b"}, metaVar="BRANCH", usage="initial branch name\n(default: master)")
    private List<String> branch;
    @Option(name="--empty-commit", usage="to create initial empty commit")
    private boolean createEmptyCommit;
    @Option(name="--max-object-size-limit", usage="max Git object size for this project")
    private String maxObjectSizeLimit;
    @Option(name="--plugin-config", usage="plugin configuration parameter with format '<plugin-name>.<parameter-name>=<value>'")
    private List<String> pluginConfigValues;
    @Argument(index=0, metaVar="NAME", usage="name of project to be created")
    private String projectName;
    @Inject
    private GerritApi gApi;
    @Inject
    private SuggestParentCandidates suggestParentCandidates;

    CreateProjectCommand() {
    }

    @Option(name="--use-contributor-agreements", aliases={"--ca"}, usage="if contributor agreement is required")
    void setUseContributorArgreements(boolean on) {
        this.contributorAgreements = InheritableBoolean.TRUE;
    }

    @Option(name="--use-signed-off-by", aliases={"--so"}, usage="if signed-off-by is required")
    void setUseSignedOffBy(boolean on) {
        this.signedOffBy = InheritableBoolean.TRUE;
    }

    @Option(name="--use-content-merge", usage="allow automatic conflict resolving within files")
    void setUseContentMerge(boolean on) {
        this.contentMerge = InheritableBoolean.TRUE;
    }

    @Option(name="--require-change-id", aliases={"--id"}, usage="if change-id is required")
    void setRequireChangeId(boolean on) {
        this.requireChangeID = InheritableBoolean.TRUE;
    }

    @Option(name="--create-new-change-for-all-not-in-target", aliases={"--ncfa"}, usage="if a new change will be created for every commit not in target branch")
    void setNewChangeForAllNotInTarget(boolean on) {
        this.createNewChangeForAllNotInTarget = InheritableBoolean.TRUE;
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            if (!this.suggestParent) {
                if (this.projectName == null) {
                    throw this.die("Project name is required.");
                }
                ProjectInput input = new ProjectInput();
                input.name = this.projectName;
                if (this.ownerIds != null) {
                    input.owners = Lists.transform(this.ownerIds, AccountGroup.UUID::get);
                }
                if (this.newParent != null) {
                    input.parent = this.newParent.getProject().getName();
                }
                input.permissionsOnly = this.permissionsOnly;
                input.description = this.projectDescription;
                input.submitType = this.submitType;
                input.useContributorAgreements = this.contributorAgreements;
                input.useSignedOffBy = this.signedOffBy;
                input.useContentMerge = this.contentMerge;
                input.requireChangeId = this.requireChangeID;
                input.createNewChangeForAllNotInTarget = this.createNewChangeForAllNotInTarget;
                input.branches = this.branch;
                input.createEmptyCommit = this.createEmptyCommit;
                input.maxObjectSizeLimit = this.maxObjectSizeLimit;
                if (this.pluginConfigValues != null) {
                    input.pluginConfigValues = this.parsePluginConfigValues(this.pluginConfigValues);
                }
                this.gApi.projects().create(input);
            } else {
                for (Project.NameKey parent : this.suggestParentCandidates.getNameKeys()) {
                    this.stdout.print(parent.get() + '\n');
                }
            }
        }
        catch (RestApiException err) {
            throw this.die(err);
        }
        catch (PermissionBackendException err) {
            throw new BaseCommand.Failure(1, "permissions unavailable", err);
        }
    }

    @VisibleForTesting
    Map<String, Map<String, ConfigValue>> parsePluginConfigValues(List<String> pluginConfigValues) throws BaseCommand.UnloggedFailure {
        HashMap<String, Map<String, ConfigValue>> m = new HashMap<String, Map<String, ConfigValue>>();
        for (String pluginConfigValue : pluginConfigValues) {
            String[] s = pluginConfigValue.split("=");
            String[] s2 = s[0].split("\\.");
            if (s.length != 2 || s2.length != 2) {
                throw this.die("Invalid plugin config value '" + pluginConfigValue + "', expected format '<plugin-name>.<parameter-name>=<value>' or '<plugin-name>.<parameter-name>=<value1,value2,...>'");
            }
            ConfigValue value = new ConfigValue();
            String v = s[1];
            if (v.contains(",")) {
                value.values = Lists.newArrayList(Splitter.on(",").split(v));
            } else {
                value.value = v;
            }
            String pluginName = s2[0];
            String paramName = s2[1];
            HashMap<String, ConfigValue> l = (HashMap<String, ConfigValue>)m.get(pluginName);
            if (l == null) {
                l = new HashMap<String, ConfigValue>();
                m.put(pluginName, l);
            }
            l.put(paramName, value);
        }
        return m;
    }
}

