/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.kohsuke.args4j.Option;

public final class SoyMsgPruner
extends AbstractSoyCompiler {
    @Option(name="--allowExternalCalls", usage="Whether to allow external calls. New projects should set this to false, and existing projects should remove existing external calls and then set this to false. It will save you a lot of headaches. Currently defaults to true for backward compatibility.")
    private boolean allowExternalCalls = true;
    @Option(name="--locales", usage="[Required] Comma-delimited list of locales.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> locales = Lists.newArrayList();
    @Option(name="--inputMsgFilePathFormat", usage="[Required] A format string that specifies how to build the path to each translated messages file. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {LOCALE}, and {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br. The format string must end with an extension matching the message file format (case-insensitive).")
    private String inputMsgFilePathFormat = "";
    @Option(name="--outputMsgFilePathFormat", usage="[Required] A format string that specifies how to build the path to each pruned output translated messages file. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {LOCALE}, and {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br. The format string must end with an extension matching the message file format (case-insensitive).")
    private String outputMsgFilePathFormat = "";
    @Option(name="--msgPluginModule", usage="Specifies the full class name of a Guice module that binds a BidirectionalSoyMsgPlugin.")
    private Module msgPluginModule;

    public static void main(String[] args) throws IOException, SoySyntaxException {
        new SoyMsgPruner().runMain(args);
    }

    @Override
    boolean acceptsSourcesAsArguments() {
        return false;
    }

    @Override
    Optional<Module> msgPluginModule() {
        return Optional.fromNullable(this.msgPluginModule);
    }

    @Override
    void compile(SoyFileSet.Builder sfsBuilder, Injector injector) throws IOException {
        sfsBuilder.setAllowExternalCalls(this.allowExternalCalls);
        SoyFileSet sfs = sfsBuilder.build();
        SoyMsgBundleHandler msgBundleHandler = injector.getInstance(SoyMsgBundleHandler.class);
        for (String locale : this.locales) {
            String inputMsgFilePath = MainEntryPointUtils.buildFilePath(this.inputMsgFilePathFormat, locale, null, this.inputPrefix);
            SoyMsgBundle origTransMsgBundle = msgBundleHandler.createFromFile(new File(inputMsgFilePath));
            if (origTransMsgBundle.getLocaleString() == null) {
                throw new IOException("Error opening or parsing message file " + inputMsgFilePath);
            }
            SoyMsgBundle prunedTransSoyMsgBundle = sfs.pruneTranslatedMsgs(origTransMsgBundle);
            String outputMsgFilePath = MainEntryPointUtils.buildFilePath(this.outputMsgFilePathFormat, locale, inputMsgFilePath, this.inputPrefix);
            msgBundleHandler.writeToTranslatedMsgsFile(prunedTransSoyMsgBundle, new SoyMsgBundleHandler.OutputFileOptions(), new File(outputMsgFilePath));
        }
    }
}

