/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import javax.annotation.Nullable;

public class LegacyInternalSyntaxException
extends SoySyntaxException {
    protected SourceLocation srcLoc = SourceLocation.UNKNOWN;
    protected String templateName;

    @Deprecated
    public static LegacyInternalSyntaxException createWithoutMetaInfo(String message) {
        return new LegacyInternalSyntaxException(message);
    }

    public static LegacyInternalSyntaxException createWithMetaInfo(String message, @Nullable SourceLocation srcLoc, @Nullable String filePath, @Nullable String templateName) {
        return LegacyInternalSyntaxException.createWithoutMetaInfo(message).associateMetaInfo(srcLoc, filePath, templateName);
    }

    public static LegacyInternalSyntaxException createWithMetaInfo(String message, SourceLocation srcLoc) {
        return LegacyInternalSyntaxException.createWithoutMetaInfo(message).associateMetaInfo(srcLoc, null, null);
    }

    protected LegacyInternalSyntaxException(Throwable cause) {
        super(cause);
    }

    protected LegacyInternalSyntaxException(String message, Throwable cause) {
        super(message, cause);
    }

    protected LegacyInternalSyntaxException(String message) {
        super(message);
    }

    public LegacyInternalSyntaxException associateMetaInfo(@Nullable SourceLocation srcLoc, @Nullable String filePath, @Nullable String templateName) {
        if (srcLoc != null) {
            Preconditions.checkArgument(filePath == null);
            if (this.srcLoc == SourceLocation.UNKNOWN) {
                this.srcLoc = srcLoc;
            } else {
                Preconditions.checkState(this.srcLoc.equals(srcLoc));
            }
        }
        if (filePath != null) {
            if (this.srcLoc == SourceLocation.UNKNOWN) {
                this.srcLoc = new SourceLocation(filePath);
            } else {
                Preconditions.checkState(this.srcLoc.getFilePath().equals(filePath));
            }
        }
        if (templateName != null) {
            if (this.templateName == null) {
                this.templateName = templateName;
            } else {
                Preconditions.checkState(this.templateName.equals(templateName));
            }
        }
        return this;
    }

    public SourceLocation getSourceLocation() {
        return this.srcLoc;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        boolean locationKnown = this.srcLoc.isKnown();
        boolean templateKnown = this.templateName != null;
        String message = super.getMessage();
        if (locationKnown) {
            if (templateKnown) {
                return "In file " + this.srcLoc + ", template " + this.templateName + ": " + message;
            }
            return "In file " + this.srcLoc + ": " + message;
        }
        if (templateKnown) {
            return "In template " + this.templateName + ": " + message;
        }
        return message;
    }
}

