/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.error.SoyError;

public final class SoyCompilationException
extends SoySyntaxException {
    private final ImmutableList<SoyError> errors;

    public SoyCompilationException(Iterable<SoyError> specificErrors) {
        this.errors = Ordering.natural().immutableSortedCopy(specificErrors);
        Preconditions.checkArgument(!this.errors.isEmpty());
    }

    public ImmutableList<SoyError> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("errors during Soy compilation\n");
        Joiner.on("\n").appendTo(sb, (Iterable<?>)this.errors);
        int numErrors = this.errors.size();
        sb.append(numErrors).append(" error").append(numErrors > 1 ? "s" : "").append('\n');
        return sb.toString();
    }
}

