/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ArrayLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
abstract class ArrayLiteral
extends CodeChunk.WithValue {
    ArrayLiteral() {
    }

    abstract ImmutableList<? extends CodeChunk.WithValue> elements();

    static ArrayLiteral create(ImmutableList<? extends CodeChunk.WithValue> elements) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CodeChunk.WithValue withValue : elements) {
            builder.addAll(withValue.initialStatements());
        }
        return new AutoValue_ArrayLiteral((ImmutableSet<CodeChunk>)builder.build(), elements);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue withValue : this.elements()) {
            withValue.collectRequires(collector);
        }
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        this.doFormatOutputExpr(ctx);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('[');
        boolean first = true;
        for (CodeChunk.WithValue withValue : this.elements()) {
            if (first) {
                first = false;
            } else {
                ctx.append(", ");
            }
            withValue.doFormatOutputExpr(ctx);
        }
        ctx.append(']');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk.WithValue withValue : this.elements()) {
            ctx.appendInitialStatements(withValue);
        }
    }
}

