/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParseErrors {
    private static final Pattern EXTRACT_LOCATION = Pattern.compile("at line (\\d+), column (\\d+).");
    private static final SoyErrorKind BAD_PHNAME_VALUE = SoyErrorKind.of("Found ''phname'' attribute that is not a valid identifier");
    private static final SoyErrorKind INVALID_STRING_LITERAL = SoyErrorKind.of("Invalid string literal found in Soy command.");
    private static final SoyErrorKind LEGACY_AND_ERROR = SoyErrorKind.of("Found use of ''&&'' instead of the ''and'' operator");
    private static final SoyErrorKind LEGACY_OR_ERROR = SoyErrorKind.of("Found use of ''||'' instead of the ''or'' operator");
    private static final SoyErrorKind LEGACY_NOT_ERROR = SoyErrorKind.of("Found use of ''!'' instead of the ''not'' operator");
    private static final SoyErrorKind LEGACY_DOUBLE_QUOTED_STRING = SoyErrorKind.of("Found use of double quotes, Soy strings use single quotes");
    private static final SoyErrorKind UNEXPECTED_EOF = SoyErrorKind.of("Unexpected end of file.  Did you forget to close an attribute value or a comment?");
    private static final SoyErrorKind UNEXPECTED_PARAM_DECL = SoyErrorKind.of("Unexpected parameter declaration. Param declarations must come before any code in your template.");
    private static final SoyErrorKind UNEXPECTED_RIGHT_BRACE = SoyErrorKind.of("Unexpected ''}''; did you mean '''{'rb'}'''?");
    private static final SoyErrorKind UNEXPECTED_TOKEN_MGR_ERROR = SoyErrorKind.of("Unexpected fatal Soy error. Please file a bug with your Soy file and we''ll take a look.  {0}");

    private ParseErrors() {
    }

    static void reportSoyFileParseException(ErrorReporter reporter, String filePath, ParseException e) {
        Token currentToken = e.currentToken;
        Token errorToken = currentToken.next != null ? currentToken.next : currentToken;
        SourceLocation location = Tokens.createSrcLoc(filePath, errorToken, new Token[0]);
        switch (errorToken.kind) {
            case 26: {
                reporter.report(location, UNEXPECTED_RIGHT_BRACE, new Object[0]);
                return;
            }
            case 91: {
                reporter.report(location, INVALID_STRING_LITERAL, new Object[0]);
                return;
            }
            case 74: {
                reporter.report(location, BAD_PHNAME_VALUE, new Object[0]);
                return;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                reporter.report(location, UNEXPECTED_PARAM_DECL, new Object[0]);
                return;
            }
            case 135: {
                reporter.report(location, LEGACY_AND_ERROR, new Object[0]);
                return;
            }
            case 136: {
                reporter.report(location, LEGACY_OR_ERROR, new Object[0]);
                return;
            }
            case 137: {
                reporter.report(location, LEGACY_NOT_ERROR, new Object[0]);
                return;
            }
            case 138: {
                reporter.report(location, LEGACY_DOUBLE_QUOTED_STRING, new Object[0]);
                return;
            }
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            expectedTokenImages.add(ParseErrors.getSoyFileParserTokenDisplayName(expected[0]));
        }
        reporter.report(location, SoyErrorKind.of("{0}"), BaseUtils.formatParseExceptionDetails(errorToken.image, ((ImmutableSet)expectedTokenImages.build()).asList()));
    }

    private static String getSoyFileParserTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 13: {
                return "attribute-value";
            }
            case 17: {
                return "{deltemplate";
            }
            case 18: {
                return "{template";
            }
            case 35: {
                return "{call";
            }
            case 37: {
                return "{/call}";
            }
            case 36: {
                return "{delcall";
            }
            case 38: {
                return "{/delcall}";
            }
            case 75: 
            case 80: {
                return "identifier";
            }
            case 0: {
                return "eof";
            }
            case 39: {
                return "{param";
            }
            case 41: {
                return "{msg";
            }
            case 42: {
                return "{fallbackmsg";
            }
            case 44: {
                return "{print";
            }
            case 45: {
                return "{xid";
            }
            case 46: {
                return "{css";
            }
            case 47: {
                return "{if";
            }
            case 48: {
                return "{elseif";
            }
            case 51: {
                return "{let";
            }
            case 53: {
                return "{for";
            }
            case 55: {
                return "{plural";
            }
            case 57: {
                return "{select";
            }
            case 59: {
                return "{switch";
            }
            case 61: {
                return "{case";
            }
            case 63: {
                return "{foreach";
            }
            case 34: {
                return "{literal";
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 97: {
                return "text";
            }
            case 96: {
                return "whitespace";
            }
            case 101: 
            case 102: 
            case 103: {
                return "number";
            }
            case 104: {
                return "string";
            }
            case 132: {
                return "an identifier";
            }
            case 134: {
                return "variable";
            }
            case 147: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return SoyFileParserConstants.tokenImage[tokenId];
    }

    static void report(ErrorReporter reporter, String filePath, LegacyInternalSyntaxException exception) {
        SourceLocation sourceLocation = exception.getSourceLocation();
        if (!sourceLocation.isKnown()) {
            sourceLocation = new SourceLocation(filePath);
        }
        reporter.report(sourceLocation, SoyErrorKind.of("{0}"), exception.getOriginalMessage());
    }

    static void reportTokenMgrError(ErrorReporter reporter, String filePath, TokenMgrError exception) {
        Matcher line;
        String message = exception.getMessage();
        if (exception.errorCode == 0 && message.contains("<EOF>") && (line = EXTRACT_LOCATION.matcher(message)).find()) {
            int startLine = Integer.parseInt(line.group(1));
            int column = Integer.parseInt(line.group(2)) + 1;
            reporter.report(new SourceLocation(filePath, startLine, column, startLine, column), UNEXPECTED_EOF, new Object[0]);
            return;
        }
        reporter.report(new SourceLocation(filePath), UNEXPECTED_TOKEN_MGR_ERROR, message);
    }
}

