/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private OutputStream out;
    private SshAgent agent;
    private AgentClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        String changeEvent = "auth-agent";
        try {
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            Session session = this.getSession();
            FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            SshAgentFactory factory = Objects.requireNonNull(manager.getAgentFactory(), "No agent factory");
            this.agent = factory.createClient(manager);
            this.client = new AgentClient();
            this.signalChannelOpenSuccess();
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e = GenericUtils.peelException(t);
            changeEvent = e.getClass().getSimpleName();
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(sshFuture -> this.closeImmediately0());
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        this.client.messageReceived(new ByteArrayBuffer(data, off, (int)len));
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    protected class AgentClient
    extends AbstractAgentClient {
        public AgentClient() {
            super(ChannelAgentForwarding.this.agent);
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            ChannelAgentForwarding.this.out.write(buf.array(), buf.rpos(), buf.available());
            ChannelAgentForwarding.this.out.flush();
        }
    }
}

