/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.agent.common.DefaultAgentForwardSupport;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.OpenChannelException;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.TcpipForwarder;
import org.apache.sshd.common.forward.TcpipForwarderFactory;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.server.x11.DefaultX11ForwardSupport;
import org.apache.sshd.server.x11.X11ForwardSupport;

public abstract class AbstractConnectionService<S extends AbstractSession>
extends AbstractInnerCloseable
implements ConnectionService {
    public static final String MAX_CONCURRENT_CHANNELS_PROP = "max-sshd-channels";
    public static final int DEFAULT_MAX_CHANNELS = Integer.MAX_VALUE;
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    protected final Map<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    protected final AtomicInteger nextChannelId = new AtomicInteger(0);
    private final AtomicReference<AgentForwardSupport> agentForwardHolder = new AtomicReference();
    private final AtomicReference<X11ForwardSupport> x11ForwardHolder = new AtomicReference();
    private final AtomicReference<TcpipForwarder> tcpipForwarderHolder = new AtomicReference();
    private final AtomicBoolean allowMoreSessions = new AtomicBoolean(true);
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final Collection<PortForwardingEventListenerManager> managersHolder = new CopyOnWriteArraySet<PortForwardingEventListenerManager>();
    private final PortForwardingEventListener listenerProxy;
    private final S sessionInstance;

    protected AbstractConnectionService(S session) {
        this.sessionInstance = (AbstractSession)Objects.requireNonNull(session, "No session");
        this.listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.getClass().getClassLoader(), this.listeners);
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public Collection<PortForwardingEventListenerManager> getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList<PortForwardingEventListenerManager>(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        return this.managersHolder.add(Objects.requireNonNull(manager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        if (manager == null) {
            return false;
        }
        return this.managersHolder.remove(manager);
    }

    public Collection<Channel> getChannels() {
        return this.channels.values();
    }

    public S getSession() {
        return this.sessionInstance;
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TcpipForwarder getTcpipForwarder() {
        TcpipForwarder forwarder;
        Session session = this.getSession();
        AtomicReference<TcpipForwarder> atomicReference = this.tcpipForwarderHolder;
        synchronized (atomicReference) {
            forwarder = this.tcpipForwarderHolder.get();
            if (forwarder != null) {
                return forwarder;
            }
            forwarder = ValidateUtils.checkNotNull(this.createTcpipForwarder(session), "No forwarder created for %s", (Object)session);
            this.tcpipForwarderHolder.set(forwarder);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getTcpipForwarder({}) created instance", (Object)session);
        }
        return forwarder;
    }

    @Override
    protected void preClose() {
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    protected TcpipForwarder createTcpipForwarder(S session) {
        FactoryManager manager = Objects.requireNonNull(((AbstractSession)session).getFactoryManager(), "No factory manager");
        TcpipForwarderFactory factory = Objects.requireNonNull(manager.getTcpipForwarderFactory(), "No forwarder factory");
        TcpipForwarder forwarder = factory.create(this);
        forwarder.addPortForwardingEventListenerManager(this);
        return forwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        X11ForwardSupport x11Support;
        Session session = this.getSession();
        AtomicReference<X11ForwardSupport> atomicReference = this.x11ForwardHolder;
        synchronized (atomicReference) {
            x11Support = this.x11ForwardHolder.get();
            if (x11Support != null) {
                return x11Support;
            }
            x11Support = ValidateUtils.checkNotNull(this.createX11ForwardSupport(session), "No X11 forwarder created for %s", (Object)session);
            this.x11ForwardHolder.set(x11Support);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getX11ForwardSupport({}) created instance", (Object)session);
        }
        return x11Support;
    }

    protected X11ForwardSupport createX11ForwardSupport(S session) {
        return new DefaultX11ForwardSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        AgentForwardSupport agentForward;
        Session session = this.getSession();
        AtomicReference<AgentForwardSupport> atomicReference = this.agentForwardHolder;
        synchronized (atomicReference) {
            agentForward = this.agentForwardHolder.get();
            if (agentForward != null) {
                return agentForward;
            }
            agentForward = ValidateUtils.checkNotNull(this.createAgentForwardSupport(session), "No agent forward created for %s", (Object)session);
            this.agentForwardHolder.set(agentForward);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getAgentForwardSupport({}) created instance", (Object)session);
        }
        return agentForward;
    }

    protected AgentForwardSupport createAgentForwardSupport(S session) {
        return new DefaultAgentForwardSupport(this);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.tcpipForwarderHolder.get(), this.agentForwardHolder.get(), this.x11ForwardHolder.get()).parallel(this.channels.values()).build();
    }

    protected int getNextChannelId() {
        return this.nextChannelId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerChannel(Channel channel) throws IOException {
        Session session = this.getSession();
        int maxChannels = session.getIntProperty(MAX_CONCURRENT_CHANNELS_PROP, Integer.MAX_VALUE);
        int curSize = this.channels.size();
        if (curSize > maxChannels) {
            throw new IllegalStateException("Currently active channels (" + curSize + ") at max.: " + maxChannels);
        }
        int channelId = this.getNextChannelId();
        channel.init(this, session, channelId);
        boolean registered = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosing()) {
                this.channels.put(channelId, channel);
                registered = true;
            }
        }
        if (!registered) {
            this.handleChannelRegistrationFailure(channel, channelId);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerChannel({})[id={}] {}", this, channelId, channel);
        }
        return channelId;
    }

    protected void handleChannelRegistrationFailure(Channel channel, int channelId) throws IOException {
        IllegalStateException reason = new IllegalStateException("Channel id=" + channelId + " not registered because session is being closed: " + this);
        AbstractChannel notifier = ValidateUtils.checkInstanceOf((Object)channel, AbstractChannel.class, "Non abstract channel for id=%d", channelId);
        notifier.signalChannelClosed(reason);
        throw reason;
    }

    @Override
    public void unregisterChannel(Channel channel) {
        Channel result = this.channels.remove(channel.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("unregisterChannel({}) result={}", (Object)channel, (Object)result);
        }
    }

    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        switch (cmd) {
            case 90: {
                this.channelOpen(buffer);
                break;
            }
            case 91: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case 92: {
                this.channelOpenFailure(buffer);
                break;
            }
            case 98: {
                this.channelRequest(buffer);
                break;
            }
            case 94: {
                this.channelData(buffer);
                break;
            }
            case 95: {
                this.channelExtendedData(buffer);
                break;
            }
            case 100: {
                this.channelFailure(buffer);
                break;
            }
            case 99: {
                this.channelSuccess(buffer);
                break;
            }
            case 93: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case 96: {
                this.channelEof(buffer);
                break;
            }
            case 97: {
                this.channelClose(buffer);
                break;
            }
            case 80: {
                this.globalRequest(buffer);
                break;
            }
            case 81: {
                this.requestSuccess(buffer);
                break;
            }
            case 82: {
                this.requestFailure(buffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported command: " + SshConstants.getCommandMessageName(cmd));
            }
        }
    }

    @Override
    public boolean isAllowMoreSessions() {
        return this.allowMoreSessions.get();
    }

    @Override
    public void setAllowMoreSessions(boolean allow) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setAllowMoreSessions({}): {}", (Object)this, (Object)allow);
        }
        this.allowMoreSessions.set(allow);
    }

    public void channelOpenConfirmation(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        int sender = buffer.getInt();
        long rwsize = buffer.getUInt();
        long rmpsize = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("channelOpenConfirmation({}) SSH_MSG_CHANNEL_OPEN_CONFIRMATION sender={}, window-size={}, packet-size={}", channel, sender, rwsize, rmpsize);
        }
        channel.handleOpenSuccess(sender, rwsize, rmpsize, buffer);
    }

    public void channelOpenFailure(Buffer buffer) throws IOException {
        AbstractClientChannel channel = (AbstractClientChannel)this.getChannel(buffer);
        int id = channel.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug("channelOpenFailure({}) Received SSH_MSG_CHANNEL_OPEN_FAILURE", (Object)channel);
        }
        this.channels.remove(id);
        channel.handleOpenFailure(buffer);
    }

    public void channelData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleData(buffer);
    }

    public void channelExtendedData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleExtendedData(buffer);
    }

    public void channelWindowAdjust(Buffer buffer) throws IOException {
        block2: {
            try {
                Channel channel = this.getChannel(buffer);
                channel.handleWindowAdjust(buffer);
            }
            catch (SshException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("channelWindowAdjust {} error: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
    }

    public void channelEof(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleEof();
    }

    public void channelClose(Buffer buffer) throws IOException {
        int recipient = buffer.getInt();
        Channel channel = this.channels.get(recipient);
        if (channel != null) {
            channel.handleClose();
        } else {
            this.log.warn("Received SSH_MSG_CHANNEL_CLOSE on unknown channel " + recipient);
        }
    }

    public void channelRequest(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleRequest(buffer);
    }

    public void channelFailure(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleFailure();
    }

    public void channelSuccess(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleSuccess();
    }

    protected Channel getChannel(Buffer buffer) throws IOException {
        return this.getChannel(buffer.getInt(), buffer);
    }

    protected Channel getChannel(int recipient, Buffer buffer) throws IOException {
        Channel channel = this.channels.get(recipient);
        if (channel == null) {
            byte[] data = buffer.array();
            int curPos = buffer.rpos();
            int cmd = curPos >= 5 ? data[curPos - 5] & 0xFF : -1;
            throw new SshException("Received " + SshConstants.getCommandMessageName(cmd) + " on unknown channel " + recipient);
        }
        return channel;
    }

    protected void channelOpen(Buffer buffer) throws Exception {
        String type = buffer.getString();
        int sender = buffer.getInt();
        long rwsize = buffer.getUInt();
        long rmpsize = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("channelOpen({}) SSH_MSG_CHANNEL_OPEN sender={}, type={}, window-size={}, packet-size={}", this, sender, type, rwsize, rmpsize);
        }
        if (this.isClosing()) {
            this.sendChannelOpenFailure(buffer, sender, 2, "Server is shutting down while attempting to open channel type=" + type, "");
            return;
        }
        if (!this.isAllowMoreSessions()) {
            this.sendChannelOpenFailure(buffer, sender, 2, "additional sessions disabled", "");
            return;
        }
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        Channel channel = NamedFactory.create(manager.getChannelFactories(), type);
        if (channel == null) {
            this.sendChannelOpenFailure(buffer, sender, 3, "Unsupported channel type: " + type, "");
            return;
        }
        int channelId = this.registerChannel(channel);
        channel.open(sender, rwsize, rmpsize, buffer).addListener(future -> {
            try {
                if (future.isOpened()) {
                    Window window = channel.getLocalWindow();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("operationComplete({}) send SSH_MSG_CHANNEL_OPEN_CONFIRMATION recipient={}, sender={}, window-size={}, packet-size={}", channel, sender, channelId, window.getSize(), window.getPacketSize());
                    }
                    Buffer buf = session.createBuffer((byte)91, 32);
                    buf.putInt(sender);
                    buf.putInt(channelId);
                    buf.putInt(window.getSize());
                    buf.putInt(window.getPacketSize());
                    session.writePacket(buf);
                } else {
                    Throwable exception = future.getException();
                    if (exception != null) {
                        String message = exception.getMessage();
                        int reasonCode = 0;
                        if (exception instanceof OpenChannelException) {
                            reasonCode = ((OpenChannelException)exception).getReasonCode();
                        } else {
                            message = exception.getClass().getSimpleName() + " while opening channel: " + message;
                        }
                        Buffer buf = session.createBuffer((byte)92, message.length() + 64);
                        this.sendChannelOpenFailure(buf, sender, reasonCode, message, "");
                    }
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("operationComplete({}) {}: {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
                session.exceptionCaught(e);
            }
        });
    }

    protected IoWriteFuture sendChannelOpenFailure(Buffer buffer, int sender, int reasonCode, String message, String lang) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendChannelOpenFailure({}) sender={}, reason={}, lang={}, message='{}'", this, sender, SshConstants.getOpenErrorCodeName(reasonCode), lang, message);
        }
        Session session = this.getSession();
        Buffer buf = session.createBuffer((byte)92, 64 + GenericUtils.length(message) + GenericUtils.length(lang));
        buf.putInt(sender);
        buf.putInt(reasonCode);
        buf.putString(message);
        buf.putString(lang);
        return session.writePacket(buf);
    }

    protected void globalRequest(Buffer buffer) throws Exception {
        Session session;
        FactoryManager manager;
        List<RequestHandler<ConnectionService>> handlers;
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("globalRequest({}) received SSH_MSG_GLOBAL_REQUEST {} want-reply={}", this, req, wantReply);
        }
        if (GenericUtils.size(handlers = (manager = Objects.requireNonNull((session = this.getSession()).getFactoryManager(), "No factory manager")).getGlobalRequestHandlers()) > 0) {
            for (RequestHandler<ConnectionService> handler : handlers) {
                RequestHandler.Result result;
                try {
                    result = handler.process(this, req, wantReply, buffer);
                }
                catch (Throwable e) {
                    this.log.warn("globalRequest({})[{}, want-reply={}] failed ({}) to process: {}", this, req, wantReply, e.getClass().getSimpleName(), e.getMessage());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("globalRequest(" + this + ")[" + req + ", want-reply=" + wantReply + "] failure details", e);
                    }
                    result = RequestHandler.Result.ReplyFailure;
                }
                if (RequestHandler.Result.Unsupported.equals((Object)result)) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("globalRequest({}) {}#process({})[want-reply={}] : {}", new Object[]{this, handler.getClass().getSimpleName(), req, wantReply, result});
                    continue;
                }
                this.sendGlobalResponse(buffer, req, result, wantReply);
                return;
            }
        }
        this.handleUnknownRequest(buffer, req, wantReply);
    }

    protected void handleUnknownRequest(Buffer buffer, String req, boolean wantReply) throws IOException {
        this.log.warn("handleUnknownRequest({}) unknown global request: {}", (Object)this, (Object)req);
        this.sendGlobalResponse(buffer, req, RequestHandler.Result.Unsupported, wantReply);
    }

    protected IoWriteFuture sendGlobalResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendGlobalResponse({})[{}] result={}, want-reply={}", new Object[]{this, req, result, wantReply});
        }
        if (RequestHandler.Result.Replied.equals((Object)result) || !wantReply) {
            return new AbstractIoWriteFuture(null){
                {
                    this.setValue(Boolean.TRUE);
                }
            };
        }
        byte cmd = RequestHandler.Result.ReplySuccess.equals((Object)result) ? (byte)81 : 82;
        Session session = this.getSession();
        Buffer rsp = session.createBuffer(cmd, 2);
        return session.writePacket(rsp);
    }

    protected void requestSuccess(Buffer buffer) throws Exception {
        ((AbstractSession)this.getSession()).requestSuccess(buffer);
    }

    protected void requestFailure(Buffer buffer) throws Exception {
        ((AbstractSession)this.getSession()).requestFailure(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }
}

