/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import com.github.parboiled1.grappa.matchers.join.JoinMatcher;
import com.github.parboiled1.grappa.matchers.trie.TrieMatcher;
import com.github.parboiled1.grappa.matchers.unicode.UnicodeCharMatcher;
import com.github.parboiled1.grappa.matchers.unicode.UnicodeRangeMatcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.parboiled.Action;
import org.parboiled.Rule;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.CustomMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.FirstOfStringsMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MemoMismatchesMatcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.StringMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.VarFramingMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class ParserStatistics
implements MatcherVisitor<ParserStatistics> {
    private static final Joiner NEWLINE = Joiner.on('\n');
    private static final Joiner COMMA = Joiner.on(", ");
    @VisibleForTesting
    public static final Set<Class<? extends Matcher>> REGULAR_MATCHER_CLASSES;
    @VisibleForTesting
    public static final Set<Class<? extends Matcher>> SPECIAL_MATCHER_CLASSES;
    private final Matcher root;
    private int totalRules;
    private final Map<Class<?>, MatcherStats<?>> regularMatcherStats = new LinkedHashMap();
    private final Map<Class<?>, MatcherStats<?>> specialMatcherStats = new LinkedHashMap();
    private final Set<Action<?>> actions = new HashSet();
    private final Set<Class<?>> actionClasses = new HashSet();

    public static ParserStatistics generateFor(Rule rule) {
        Preconditions.checkNotNull(rule, "rule");
        Matcher matcher = (Matcher)rule;
        return matcher.accept(new ParserStatistics(matcher));
    }

    private ParserStatistics(Matcher root) {
        this.root = root;
        for (Class<? extends Matcher> c : REGULAR_MATCHER_CLASSES) {
            this.regularMatcherStats.put(c, MatcherStats.forClass(c, false));
        }
        for (Class<? extends Matcher> c : SPECIAL_MATCHER_CLASSES) {
            this.specialMatcherStats.put(c, MatcherStats.forClass(c, true));
        }
        this.countSpecials(root);
    }

    public int getTotalRules() {
        return this.totalRules;
    }

    public Map<Class<?>, MatcherStats<?>> getRegularMatcherStats() {
        return Collections.unmodifiableMap(this.regularMatcherStats);
    }

    public Map<Class<?>, MatcherStats<?>> getSpecialMatcherStats() {
        return Collections.unmodifiableMap(this.specialMatcherStats);
    }

    public Set<Action<?>> getActions() {
        return Collections.unmodifiableSet(this.actions);
    }

    public Set<Class<?>> getActionClasses() {
        return Collections.unmodifiableSet(this.actionClasses);
    }

    @Override
    public ParserStatistics visit(ActionMatcher matcher) {
        if (this.actions.add(matcher.action)) {
            ++this.totalRules;
            this.actionClasses.add(matcher.action.getClass());
        }
        return this;
    }

    @Override
    public ParserStatistics visit(AnyMatcher matcher) {
        return this.doVisit(matcher, AnyMatcher.class);
    }

    @Override
    public ParserStatistics visit(CharIgnoreCaseMatcher matcher) {
        return this.doVisit(matcher, CharIgnoreCaseMatcher.class);
    }

    @Override
    public ParserStatistics visit(CharMatcher matcher) {
        return this.doVisit(matcher, CharMatcher.class);
    }

    @Override
    public ParserStatistics visit(UnicodeCharMatcher matcher) {
        return this.doVisit(matcher, UnicodeCharMatcher.class);
    }

    @Override
    public ParserStatistics visit(CustomMatcher matcher) {
        return this.doVisit(matcher, CustomMatcher.class);
    }

    @Override
    public ParserStatistics visit(CharRangeMatcher matcher) {
        return this.doVisit(matcher, CharRangeMatcher.class);
    }

    @Override
    public ParserStatistics visit(UnicodeRangeMatcher matcher) {
        return this.doVisit(matcher, UnicodeRangeMatcher.class);
    }

    @Override
    public ParserStatistics visit(AnyOfMatcher matcher) {
        return this.doVisit(matcher, AnyOfMatcher.class);
    }

    @Override
    public ParserStatistics visit(TrieMatcher matcher) {
        return this.doVisit(matcher, TrieMatcher.class);
    }

    @Override
    public ParserStatistics visit(EmptyMatcher matcher) {
        return this.doVisit(matcher, EmptyMatcher.class);
    }

    @Override
    public ParserStatistics visit(FirstOfMatcher matcher) {
        return this.doVisit(matcher, FirstOfMatcher.class);
    }

    @Override
    public ParserStatistics visit(NothingMatcher matcher) {
        return this.doVisit(matcher, NothingMatcher.class);
    }

    @Override
    public ParserStatistics visit(JoinMatcher matcher) {
        return this.doVisit(matcher, JoinMatcher.class);
    }

    @Override
    public ParserStatistics visit(OneOrMoreMatcher matcher) {
        return this.doVisit(matcher, OneOrMoreMatcher.class);
    }

    @Override
    public ParserStatistics visit(OptionalMatcher matcher) {
        return this.doVisit(matcher, OptionalMatcher.class);
    }

    @Override
    public ParserStatistics visit(SequenceMatcher matcher) {
        return this.doVisit(matcher, SequenceMatcher.class);
    }

    @Override
    public ParserStatistics visit(TestMatcher matcher) {
        return this.doVisit(matcher, TestMatcher.class);
    }

    @Override
    public ParserStatistics visit(TestNotMatcher matcher) {
        return this.doVisit(matcher, TestNotMatcher.class);
    }

    @Override
    public ParserStatistics visit(ZeroOrMoreMatcher matcher) {
        return this.doVisit(matcher, ZeroOrMoreMatcher.class);
    }

    private <M extends Matcher> ParserStatistics doVisit(M matcher) {
        return this.doVisit(matcher, matcher.getClass());
    }

    private <M extends Matcher> ParserStatistics doVisit(M matcher, Class<? extends M> c) {
        MatcherStats<?> stats = this.getMatcherStats(c, matcher.getClass());
        Preconditions.checkNotNull(stats, c.getCanonicalName() + " not recorded??");
        if (((MatcherStats)stats).recordInstance(matcher)) {
            ++this.totalRules;
            for (Matcher child : matcher.getChildren()) {
                this.countSpecials(child);
                child.accept(this);
            }
        }
        return this;
    }

    private MatcherStats<?> getMatcherStats(Class<?> base, Class<?> real) {
        MatcherStats<?> ret = this.regularMatcherStats.get(real);
        if (ret != null) {
            return ret;
        }
        ret = this.regularMatcherStats.get(base);
        if (ret != null) {
            return ret;
        }
        ret = this.specialMatcherStats.get(real);
        if (ret != null) {
            return ret;
        }
        return Preconditions.checkNotNull(this.specialMatcherStats.get(base), "class " + real.getCanonicalName() + " not recorded in stats");
    }

    private void countSpecials(Matcher matcher) {
        Class<?> matcherClass = matcher.getClass();
        if (SPECIAL_MATCHER_CLASSES.contains(matcherClass)) {
            ((MatcherStats)this.specialMatcherStats.get(matcherClass)).recordInstance(matcher);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Parser statistics for rule '").append(this.root).append("':\n");
        sb.append("    Total rules       : ").append(this.totalRules).append('\n');
        sb.append("        Actions       : ").append(this.actions.size()).append('\n');
        NEWLINE.appendTo(sb, (Iterable<?>)this.regularMatcherStats.values());
        sb.append("\n\n");
        sb.append("    Action Classes    : ").append(this.actionClasses.size()).append('\n');
        NEWLINE.appendTo(sb, (Iterable<?>)this.specialMatcherStats.values());
        return sb.append('\n').toString();
    }

    public String printActionClassInstances() {
        StringBuilder sb = new StringBuilder("Action classes and their instances for rule '").append(this.root).append("':\n");
        for (String line : this.printActionClassLines()) {
            sb.append("    ").append(line).append('\n');
        }
        return sb.toString();
    }

    private List<String> printActionClassLines() {
        ArrayList<String> lines = new ArrayList<String>();
        int anonymous = 0;
        for (Class<?> c : this.actionClasses) {
            String name = c.getSimpleName();
            if (name.isEmpty()) {
                ++anonymous;
                continue;
            }
            lines.add(name + " : " + COMMA.join(this.printActionClassInstances(c)));
        }
        Collections.sort(lines);
        if (anonymous > 0) {
            lines.add("and " + anonymous + " anonymous instance(s)");
        }
        return lines;
    }

    private List<String> printActionClassInstances(Class<?> actionClass) {
        ArrayList<String> actionNames = new ArrayList<String>();
        for (Action<?> action : this.actions) {
            if (!action.getClass().equals(actionClass)) continue;
            actionNames.add(action.toString());
        }
        Collections.sort(actionNames);
        return actionNames;
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add(AnyMatcher.class);
        builder.add(CharIgnoreCaseMatcher.class);
        builder.add(CharMatcher.class);
        builder.add(UnicodeCharMatcher.class);
        builder.add(CustomMatcher.class);
        builder.add(CharRangeMatcher.class);
        builder.add(UnicodeRangeMatcher.class);
        builder.add(AnyOfMatcher.class);
        builder.add(EmptyMatcher.class);
        builder.add(TrieMatcher.class);
        builder.add(FirstOfMatcher.class);
        builder.add(FirstOfStringsMatcher.class);
        builder.add(NothingMatcher.class);
        builder.add(JoinMatcher.class);
        builder.add(OneOrMoreMatcher.class);
        builder.add(OptionalMatcher.class);
        builder.add(SequenceMatcher.class);
        builder.add(StringMatcher.class);
        builder.add(TestMatcher.class);
        builder.add(TestNotMatcher.class);
        builder.add(ZeroOrMoreMatcher.class);
        REGULAR_MATCHER_CLASSES = builder.build();
        builder = ImmutableSet.builder();
        builder.add(ProxyMatcher.class);
        builder.add(VarFramingMatcher.class);
        builder.add(MemoMismatchesMatcher.class);
        SPECIAL_MATCHER_CLASSES = builder.build();
    }

    @VisibleForTesting
    public static final class MatcherStats<T extends Matcher> {
        private final String name;
        private final Set<Matcher> instances = new HashSet<Matcher>();

        private static <M extends Matcher> MatcherStats<M> forClass(Class<M> matcherClass, boolean special) {
            return new MatcherStats<M>(matcherClass, special);
        }

        private MatcherStats(Class<T> matcherClass, boolean special) {
            this.name = MatcherStats.generateName(matcherClass.getSimpleName(), special);
        }

        private boolean recordInstance(Matcher matcher) {
            return this.instances.add(matcher);
        }

        public int getInstanceCount() {
            return this.instances.size();
        }

        private static String generateName(String name, boolean special) {
            int position;
            char[] array = new char[22];
            Arrays.fill(array, ' ');
            CharBuffer buf = CharBuffer.wrap(array);
            String realName = special ? name + 's' : name.replaceFirst("Matcher$", "");
            int n = position = special ? 4 : 8;
            while (realName.length() + position > 22) {
                position -= 4;
            }
            buf.position(position);
            buf.put(realName).rewind();
            return buf.toString();
        }

        public String toString() {
            return this.name + ": " + this.instances.size();
        }
    }
}

