/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInput;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public interface Changes {
    public ChangeApi id(int var1) throws RestApiException;

    public ChangeApi id(String var1) throws RestApiException;

    public ChangeApi id(String var1, String var2, String var3) throws RestApiException;

    public ChangeApi id(String var1, int var2) throws RestApiException;

    public ChangeApi create(ChangeInput var1) throws RestApiException;

    public QueryRequest query();

    public QueryRequest query(String var1);

    public static class NotImplemented
    implements Changes {
        @Override
        public ChangeApi id(int id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi id(String triplet) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi id(String project, String branch, String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi id(String project, int id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi create(ChangeInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query() {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query(String query) {
            throw new NotImplementedException();
        }
    }

    public static abstract class QueryRequest {
        private String query;
        private int limit;
        private int start;
        private EnumSet<ListChangesOption> options = EnumSet.noneOf(ListChangesOption.class);

        public abstract List<ChangeInfo> get() throws RestApiException;

        public QueryRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public QueryRequest withOption(ListChangesOption options) {
            this.options.add(options);
            return this;
        }

        public QueryRequest withOptions(ListChangesOption ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public QueryRequest withOptions(EnumSet<ListChangesOption> options) {
            this.options = options;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getStart() {
            return this.start;
        }

        public EnumSet<ListChangesOption> getOptions() {
            return this.options;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('{').append(this.query);
            if (this.limit != 0) {
                sb.append(", limit=").append(this.limit);
            }
            if (this.start != 0) {
                sb.append(", start=").append(this.start);
            }
            if (!this.options.isEmpty()) {
                sb.append("options=").append(this.options);
            }
            return sb.append('}').toString();
        }
    }
}

