/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.auth.oauth.OAuthLoginProvider;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.AuthResult;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ProjectOAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ProjectOAuthFilter.class);
    private static final String REALM_NAME = "Gerrit Code Review";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC = "Basic ";
    private static final String GIT_COOKIE_PREFIX = "git-";
    private final DynamicItem<WebSession> session;
    private final DynamicMap<OAuthLoginProvider> loginProviders;
    private final AccountCache accountCache;
    private final AccountManager accountManager;
    private final String gitOAuthProvider;
    private final boolean userNameToLowerCase;
    private String defaultAuthPlugin;
    private String defaultAuthProvider;

    @Inject
    ProjectOAuthFilter(DynamicItem<WebSession> session, DynamicMap<OAuthLoginProvider> pluginsProvider, AccountCache accountCache, AccountManager accountManager, @GerritServerConfig Config gerritConfig) {
        this.session = session;
        this.loginProviders = pluginsProvider;
        this.accountCache = accountCache;
        this.accountManager = accountManager;
        this.gitOAuthProvider = gerritConfig.getString("auth", null, "gitOAuthProvider");
        this.userNameToLowerCase = gerritConfig.getBoolean("auth", null, "userNameToLowerCase", false);
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        if (Strings.isNullOrEmpty(this.gitOAuthProvider)) {
            this.pickOnlyProvider();
        } else {
            this.pickConfiguredProvider();
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Response rsp = new Response((HttpServletResponse)response);
        if (this.verify(req, rsp)) {
            chain.doFilter(req, rsp);
        }
    }

    private boolean verify(HttpServletRequest req, Response rsp) throws IOException {
        AuthInfo authInfo = null;
        String hdr = req.getHeader(AUTHORIZATION);
        if (hdr != null && hdr.startsWith(BASIC)) {
            authInfo = this.extractAuthInfo(hdr, ProjectOAuthFilter.encoding(req));
            if (authInfo == null) {
                rsp.sendError(401);
                return false;
            }
        } else {
            Cookie cookie = ProjectOAuthFilter.findGitCookie(req);
            if (cookie != null) {
                authInfo = this.extractAuthInfo(cookie);
                if (authInfo == null) {
                    rsp.sendError(401);
                    return false;
                }
            } else {
                return true;
            }
        }
        if (Strings.isNullOrEmpty(authInfo.tokenOrSecret)) {
            rsp.sendError(401);
            return false;
        }
        AccountState who = this.accountCache.getByUsername(authInfo.username);
        if (who == null || !who.getAccount().isActive()) {
            log.warn("Authentication failed for " + authInfo.username + ": account inactive or not provisioned in Gerrit");
            rsp.sendError(401);
            return false;
        }
        AuthRequest authRequest = AuthRequest.forExternalUser(authInfo.username);
        authRequest.setEmailAddress(who.getAccount().getPreferredEmail());
        authRequest.setDisplayName(who.getAccount().getFullName());
        authRequest.setPassword(authInfo.tokenOrSecret);
        authRequest.setAuthPlugin(authInfo.pluginName);
        authRequest.setAuthProvider(authInfo.exportName);
        try {
            AuthResult authResult = this.accountManager.authenticate(authRequest);
            WebSession ws = this.session.get();
            ws.setUserAccountId(authResult.getAccountId());
            ws.setAccessPathOk(AccessPath.GIT, true);
            ws.setAccessPathOk(AccessPath.REST_API, true);
            return true;
        }
        catch (AccountException e) {
            log.warn("Authentication failed for " + authInfo.username, e);
            rsp.sendError(401);
            return false;
        }
    }

    private void pickOnlyProvider() throws ServletException {
        try {
            DynamicMap.Entry loginProvider = (DynamicMap.Entry)((Object)Iterables.getOnlyElement(this.loginProviders));
            this.defaultAuthPlugin = loginProvider.getPluginName();
            this.defaultAuthProvider = loginProvider.getExportName();
        }
        catch (NoSuchElementException e) {
            throw new ServletException("No OAuth login provider installed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void pickConfiguredProvider() throws ServletException {
        int splitPos = this.gitOAuthProvider.lastIndexOf(58);
        if (splitPos < 1 || splitPos == this.gitOAuthProvider.length() - 1) {
            throw new ServletException("OAuth login provider configuration is invalid: Must be of the form pluginName:providerName");
        }
        this.defaultAuthPlugin = this.gitOAuthProvider.substring(0, splitPos);
        this.defaultAuthProvider = this.gitOAuthProvider.substring(splitPos + 1);
        OAuthLoginProvider provider = this.loginProviders.get(this.defaultAuthPlugin, this.defaultAuthProvider);
        if (provider == null) {
            throw new ServletException("Configured OAuth login provider " + this.gitOAuthProvider + " wasn't installed");
        }
    }

    private AuthInfo extractAuthInfo(String hdr, String encoding) throws UnsupportedEncodingException {
        byte[] decoded = Base64.decodeBase64(hdr.substring(BASIC.length()));
        String usernamePassword = new String(decoded, encoding);
        int splitPos = usernamePassword.indexOf(58);
        if (splitPos < 1 || splitPos == usernamePassword.length() - 1) {
            return null;
        }
        return new AuthInfo(usernamePassword.substring(0, splitPos), usernamePassword.substring(splitPos + 1), this.defaultAuthPlugin, this.defaultAuthProvider);
    }

    private AuthInfo extractAuthInfo(Cookie cookie) throws UnsupportedEncodingException {
        String exportName;
        String username = URLDecoder.decode(cookie.getName().substring(GIT_COOKIE_PREFIX.length()), StandardCharsets.UTF_8.name());
        String value = cookie.getValue();
        int splitPos = value.lastIndexOf(64);
        if (splitPos < 1 || splitPos == value.length() - 1) {
            return new AuthInfo(username, cookie.getValue(), this.defaultAuthPlugin, this.defaultAuthProvider);
        }
        String token = value.substring(0, splitPos);
        String providerId = value.substring(splitPos + 1);
        if ((splitPos = providerId.lastIndexOf(58)) < 1 || splitPos == providerId.length() - 1) {
            return null;
        }
        String pluginName = providerId.substring(0, splitPos);
        OAuthLoginProvider provider = this.loginProviders.get(pluginName, exportName = providerId.substring(splitPos + 1));
        if (provider == null) {
            return null;
        }
        return new AuthInfo(username, token, pluginName, exportName);
    }

    private static String encoding(HttpServletRequest req) {
        return MoreObjects.firstNonNull(req.getCharacterEncoding(), StandardCharsets.UTF_8.name());
    }

    private static Cookie findGitCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().startsWith(GIT_COOKIE_PREFIX)) continue;
                return cookie;
            }
        }
        return null;
    }

    private static class Response
    extends HttpServletResponseWrapper {
        private static final String WWW_AUTHENTICATE = "WWW-Authenticate";

        Response(HttpServletResponse rsp) {
            super(rsp);
        }

        private void status(int sc) {
            if (sc == 401) {
                StringBuilder v = new StringBuilder();
                v.append(ProjectOAuthFilter.BASIC);
                v.append("realm=\"").append(ProjectOAuthFilter.REALM_NAME).append("\"");
                this.setHeader(WWW_AUTHENTICATE, v.toString());
            } else if (this.containsHeader(WWW_AUTHENTICATE)) {
                this.setHeader(WWW_AUTHENTICATE, null);
            }
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            this.status(sc);
            super.sendError(sc, msg);
        }

        @Override
        public void sendError(int sc) throws IOException {
            this.status(sc);
            super.sendError(sc);
        }

        @Override
        @Deprecated
        public void setStatus(int sc, String sm) {
            this.status(sc);
            super.setStatus(sc, sm);
        }

        @Override
        public void setStatus(int sc) {
            this.status(sc);
            super.setStatus(sc);
        }
    }

    private class AuthInfo {
        private final String username;
        private final String tokenOrSecret;
        private final String pluginName;
        private final String exportName;

        private AuthInfo(String username, String tokenOrSecret, String pluginName, String exportName) {
            this.username = ProjectOAuthFilter.this.userNameToLowerCase ? username.toLowerCase(Locale.US) : username;
            this.tokenOrSecret = tokenOrSecret;
            this.pluginName = pluginName;
            this.exportName = exportName;
        }
    }
}

