/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.cache.Cache;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.httpd.raw.ResourceServlet;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;

class PolyGerritUiServlet
extends ResourceServlet {
    private static final long serialVersionUID = 1L;
    private static final FileTime NOW = FileTime.fromMillis(TimeUtil.nowMs());
    private final Path ui;

    PolyGerritUiServlet(Cache<Path, ResourceServlet.Resource> cache, Path ui) {
        super(cache, true);
        this.ui = ui;
    }

    @Override
    protected Path getResourcePath(String pathInfo) {
        return this.ui.resolve(pathInfo);
    }

    @Override
    protected FileTime getLastModifiedTime(Path p) throws IOException {
        if (this.ui.getFileSystem().equals(FileSystems.getDefault())) {
            return super.getLastModifiedTime(p);
        }
        return NOW;
    }
}

