/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.extensions.client.Comment;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;
import java.util.Objects;

public final class PatchLineComment {
    public static final char STATUS_DRAFT = 'd';
    public static final char STATUS_PUBLISHED = 'P';
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected int lineNbr;
    @Column(id=3, name="author_id")
    protected Account.Id author;
    @Column(id=4)
    protected Timestamp writtenOn;
    @Column(id=5)
    protected char status;
    @Column(id=6)
    protected short side;
    @Column(id=7, notNull=false, length=0x7FFFFFFF)
    protected String message;
    @Column(id=8, length=40, notNull=false)
    protected String parentUuid;
    @Column(id=9, notNull=false)
    protected CommentRange range;
    @Column(id=10, notNull=false)
    protected String tag;
    @Column(id=11, notNull=false)
    protected Account.Id realAuthor;
    @Column(id=12)
    protected boolean unresolved;
    protected RevId revId;

    public static PatchLineComment from(Change.Id changeId, Status status, Comment c) {
        Key key = new Key(new Patch.Key(new PatchSet.Id(changeId, c.key.patchSetId), c.key.filename), c.key.uuid);
        PatchLineComment plc = new PatchLineComment(key, c.lineNbr, c.author.getId(), c.parentUuid, c.writtenOn);
        plc.setSide(c.side);
        plc.setMessage(c.message);
        if (c.range != null) {
            Comment.Range r = c.range;
            plc.setRange(new CommentRange(r.startLine, r.startChar, r.endLine, r.endChar));
        }
        plc.setTag(c.tag);
        plc.setRevId(new RevId(c.revId));
        plc.setStatus(status);
        plc.setRealAuthor(c.getRealAuthor().getId());
        plc.setUnresolved(c.unresolved);
        return plc;
    }

    protected PatchLineComment() {
    }

    public PatchLineComment(Key id, int line, Account.Id a, String parentUuid, Timestamp when) {
        this.key = id;
        this.lineNbr = line;
        this.author = a;
        this.setParentUuid(parentUuid);
        this.setStatus(Status.DRAFT);
        this.setWrittenOn(when);
    }

    public PatchLineComment(PatchLineComment o) {
        this.key = o.key;
        this.lineNbr = o.lineNbr;
        this.author = o.author;
        this.realAuthor = o.realAuthor;
        this.writtenOn = o.writtenOn;
        this.status = o.status;
        this.side = o.side;
        this.message = o.message;
        this.parentUuid = o.parentUuid;
        this.revId = o.revId;
        if (o.range != null) {
            this.range = new CommentRange(o.range.getStartLine(), o.range.getStartCharacter(), o.range.getEndLine(), o.range.getEndCharacter());
        }
    }

    public Key getKey() {
        return this.key;
    }

    public PatchSet.Id getPatchSetId() {
        return this.key.getParentKey().getParentKey();
    }

    public int getLine() {
        return this.lineNbr;
    }

    public void setLine(int line) {
        this.lineNbr = line;
    }

    public Account.Id getAuthor() {
        return this.author;
    }

    public Account.Id getRealAuthor() {
        return this.realAuthor != null ? this.realAuthor : this.getAuthor();
    }

    public void setRealAuthor(Account.Id id) {
        this.realAuthor = Objects.equals(this.getAuthor(), id) ? null : id;
    }

    public Timestamp getWrittenOn() {
        return this.writtenOn;
    }

    public Status getStatus() {
        return Status.forCode(this.status);
    }

    public void setStatus(Status s) {
        this.status = s.getCode();
    }

    public short getSide() {
        return this.side;
    }

    public void setSide(short s) {
        this.side = s;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public void setWrittenOn(Timestamp ts) {
        this.writtenOn = ts;
    }

    public String getParentUuid() {
        return this.parentUuid;
    }

    public void setParentUuid(String inReplyTo) {
        this.parentUuid = inReplyTo;
    }

    public void setRange(Comment.Range r) {
        this.range = r != null ? new CommentRange(r.startLine, r.startCharacter, r.endLine, r.endCharacter) : null;
    }

    public void setRange(CommentRange r) {
        this.range = r;
    }

    public CommentRange getRange() {
        return this.range;
    }

    public void setRevId(RevId rev) {
        this.revId = rev;
    }

    public RevId getRevId() {
        return this.revId;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setUnresolved(Boolean unresolved) {
        this.unresolved = unresolved;
    }

    public Boolean getUnresolved() {
        return this.unresolved;
    }

    public Comment asComment(String serverId) {
        Comment c = new Comment(this.key.asCommentKey(), this.author, this.writtenOn, this.side, this.message, serverId, this.unresolved);
        c.setRevId(this.revId);
        c.setRange(this.range);
        c.lineNbr = this.lineNbr;
        c.parentUuid = this.parentUuid;
        c.tag = this.tag;
        c.setRealAuthor(this.getRealAuthor());
        return c;
    }

    public boolean equals(Object o) {
        if (o instanceof PatchLineComment) {
            PatchLineComment c = (PatchLineComment)o;
            return Objects.equals(this.key, c.getKey()) && Objects.equals(this.lineNbr, c.getLine()) && Objects.equals(this.author, c.getAuthor()) && Objects.equals(this.writtenOn, c.getWrittenOn()) && Objects.equals(Character.valueOf(this.status), Character.valueOf(c.getStatus().getCode())) && Objects.equals(this.side, c.getSide()) && Objects.equals(this.message, c.getMessage()) && Objects.equals(this.parentUuid, c.getParentUuid()) && Objects.equals(this.range, c.getRange()) && Objects.equals(this.revId, c.getRevId()) && Objects.equals(this.tag, c.getTag()) && Objects.equals(this.unresolved, c.getUnresolved());
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PatchLineComment{");
        builder.append("key=").append(this.key).append(',');
        builder.append("lineNbr=").append(this.lineNbr).append(',');
        builder.append("author=").append(this.author.get()).append(',');
        builder.append("realAuthor=").append(this.realAuthor != null ? Integer.valueOf(this.realAuthor.get()) : "").append(',');
        builder.append("writtenOn=").append(this.writtenOn.toString()).append(',');
        builder.append("status=").append(this.status).append(',');
        builder.append("side=").append(this.side).append(',');
        builder.append("message=").append(Objects.toString(this.message, "")).append(',');
        builder.append("parentUuid=").append(Objects.toString(this.parentUuid, "")).append(',');
        builder.append("range=").append(Objects.toString(this.range, "")).append(',');
        builder.append("revId=").append(this.revId != null ? this.revId.get() : "").append(',');
        builder.append("tag=").append(Objects.toString(this.tag, "")).append(',');
        builder.append("unresolved=").append(this.unresolved);
        builder.append('}');
        return builder.toString();
    }

    public static enum Status {
        DRAFT('d'),
        PUBLISHED('P');

        private final char code;

        private Status(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static Status forCode(char c) {
            for (Status s : Status.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }

    public static class Key
    extends StringKey<Patch.Key> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, name="--NONE--")
        protected Patch.Key patchKey;
        @Column(id=2, length=40)
        protected String uuid;

        public static Key from(Change.Id changeId, Comment.Key key) {
            return new Key(new Patch.Key(new PatchSet.Id(changeId, key.patchSetId), key.filename), key.uuid);
        }

        protected Key() {
            this.patchKey = new Patch.Key();
        }

        public Key(Patch.Key p, String uuid) {
            this.patchKey = p;
            this.uuid = uuid;
        }

        @Override
        public Patch.Key getParentKey() {
            return this.patchKey;
        }

        @Override
        public String get() {
            return this.uuid;
        }

        @Override
        public void set(String newValue) {
            this.uuid = newValue;
        }

        public Comment.Key asCommentKey() {
            return new Comment.Key(this.get(), this.getParentKey().getFileName(), this.getParentKey().getParentKey().get());
        }
    }
}

