/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.args4j.AccountGroupIdHandler;
import com.google.gerrit.server.args4j.AccountGroupUUIDHandler;
import com.google.gerrit.server.args4j.AccountIdHandler;
import com.google.gerrit.server.args4j.ChangeIdHandler;
import com.google.gerrit.server.args4j.ObjectIdHandler;
import com.google.gerrit.server.args4j.PatchSetIdHandler;
import com.google.gerrit.server.args4j.ProjectControlHandler;
import com.google.gerrit.server.args4j.SocketAddressHandler;
import com.google.gerrit.server.args4j.TimestampHandler;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gerrit.util.cli.OptionHandlerUtil;
import com.google.gerrit.util.cli.OptionHandlers;
import java.net.SocketAddress;
import java.sql.Timestamp;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.args4j.spi.OptionHandler;

public class CmdLineParserModule
extends FactoryModule {
    @Override
    protected void configure() {
        this.factory(CmdLineParser.Factory.class);
        this.bind(OptionHandlers.class);
        this.registerOptionHandler(Account.Id.class, AccountIdHandler.class);
        this.registerOptionHandler(AccountGroup.Id.class, AccountGroupIdHandler.class);
        this.registerOptionHandler(AccountGroup.UUID.class, AccountGroupUUIDHandler.class);
        this.registerOptionHandler(Change.Id.class, ChangeIdHandler.class);
        this.registerOptionHandler(ObjectId.class, ObjectIdHandler.class);
        this.registerOptionHandler(PatchSet.Id.class, PatchSetIdHandler.class);
        this.registerOptionHandler(ProjectControl.class, ProjectControlHandler.class);
        this.registerOptionHandler(SocketAddress.class, SocketAddressHandler.class);
        this.registerOptionHandler(Timestamp.class, TimestampHandler.class);
    }

    private <T> void registerOptionHandler(Class<T> type, Class<? extends OptionHandler<T>> impl) {
        this.install(OptionHandlerUtil.moduleFor(type, impl));
    }
}

