/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.group.InternalGroupDescription;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class GroupMembers {
    private final GroupCache groupCache;
    private final GroupControl.Factory groupControlFactory;
    private final AccountCache accountCache;
    private final ProjectControl.GenericFactory projectControl;
    private final CurrentUser currentUser;

    @Inject
    GroupMembers(GroupCache groupCache, GroupControl.Factory groupControlFactory, AccountCache accountCache, ProjectControl.GenericFactory projectControl, @Assisted CurrentUser currentUser) {
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.accountCache = accountCache;
        this.projectControl = projectControl;
        this.currentUser = currentUser;
    }

    public Set<Account> listAccounts(AccountGroup.UUID groupUUID, Project.NameKey project) throws NoSuchGroupException, NoSuchProjectException, OrmException, IOException {
        return this.listAccounts(groupUUID, project, new HashSet<AccountGroup.UUID>());
    }

    private Set<Account> listAccounts(AccountGroup.UUID groupUUID, Project.NameKey project, Set<AccountGroup.UUID> seen) throws NoSuchGroupException, OrmException, NoSuchProjectException, IOException {
        if (SystemGroupBackend.PROJECT_OWNERS.equals(groupUUID)) {
            return this.getProjectOwners(project, seen);
        }
        Optional<InternalGroup> group = this.groupCache.get(groupUUID);
        if (group.isPresent()) {
            return this.getGroupMembers(group.get(), project, seen);
        }
        return Collections.emptySet();
    }

    private Set<Account> getProjectOwners(Project.NameKey project, Set<AccountGroup.UUID> seen) throws NoSuchProjectException, NoSuchGroupException, OrmException, IOException {
        seen.add(SystemGroupBackend.PROJECT_OWNERS);
        if (project == null) {
            return Collections.emptySet();
        }
        Set<AccountGroup.UUID> ownerGroups = this.projectControl.controlFor(project, this.currentUser).getProjectState().getAllOwners();
        HashSet<Account> projectOwners = new HashSet<Account>();
        for (AccountGroup.UUID ownerGroup : ownerGroups) {
            if (seen.contains(ownerGroup)) continue;
            projectOwners.addAll(this.listAccounts(ownerGroup, project, seen));
        }
        return projectOwners;
    }

    private Set<Account> getGroupMembers(InternalGroup group, Project.NameKey project, Set<AccountGroup.UUID> seen) throws NoSuchGroupException, OrmException, NoSuchProjectException, IOException {
        seen.add(group.getGroupUUID());
        GroupControl groupControl = this.groupControlFactory.controlFor(new InternalGroupDescription(group));
        Set directMembers = group.getMembers().stream().filter(groupControl::canSeeMember).map(this.accountCache::get).map(AccountState::getAccount).collect(ImmutableSet.toImmutableSet());
        HashSet<Account> indirectMembers = new HashSet<Account>();
        if (groupControl.canSeeGroup()) {
            for (AccountGroup.UUID subgroupUuid : group.getSubgroups()) {
                if (seen.contains(subgroupUuid)) continue;
                indirectMembers.addAll(this.listAccounts(subgroupUuid, project, seen));
            }
        }
        return Sets.union(directMembers, indirectMembers);
    }

    public static interface Factory {
        public GroupMembers create(CurrentUser var1);
    }
}

