/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.IncludingGroupMembership;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.InternalGroupDescription;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class InternalGroupBackend
implements GroupBackend {
    private final GroupControl.Factory groupControlFactory;
    private final GroupCache groupCache;
    private final Groups groups;
    private final SchemaFactory<ReviewDb> schema;
    private final IncludingGroupMembership.Factory groupMembershipFactory;

    @Inject
    InternalGroupBackend(GroupControl.Factory groupControlFactory, GroupCache groupCache, Groups groups, SchemaFactory<ReviewDb> schema, IncludingGroupMembership.Factory groupMembershipFactory) {
        this.groupControlFactory = groupControlFactory;
        this.groupCache = groupCache;
        this.groups = groups;
        this.schema = schema;
        this.groupMembershipFactory = groupMembershipFactory;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return ObjectId.isId(uuid.get());
    }

    @Override
    public GroupDescription.Internal get(AccountGroup.UUID uuid) {
        if (!this.handles(uuid)) {
            return null;
        }
        return this.groupCache.get(uuid).map(InternalGroupDescription::new).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<GroupReference> suggest(String name, ProjectState project) {
        try (ReviewDb db = this.schema.open();){
            Collection collection = this.groups.getAll(db).filter(group -> InternalGroupBackend.startsWithIgnoreCase(group, name)).filter(this::isVisible).map(GroupReference::forGroup).collect(Collectors.toList());
            return collection;
        }
        catch (OrmException e) {
            return ImmutableList.of();
        }
    }

    private static boolean startsWithIgnoreCase(AccountGroup group, String name) {
        return group.getName().regionMatches(true, 0, name, 0, name.length());
    }

    private boolean isVisible(AccountGroup group) {
        return this.groupControlFactory.controlFor(group).isVisible();
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return this.groupMembershipFactory.create(user);
    }

    @Override
    public boolean isVisibleToAll(AccountGroup.UUID uuid) {
        GroupDescription.Internal g = this.get(uuid);
        return g != null && g.isVisibleToAll();
    }
}

