/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class GetPastAssignees
implements RestReadView<ChangeResource> {
    private final AccountLoader.Factory accountLoaderFactory;

    @Inject
    GetPastAssignees(AccountLoader.Factory accountLoaderFactory) {
        this.accountLoaderFactory = accountLoaderFactory;
    }

    public Response<List<AccountInfo>> apply(ChangeResource rsrc) throws OrmException {
        ImmutableSet<Account.Id> pastAssignees = ((ChangeNotes)rsrc.getNotes().load()).getPastAssignees();
        if (pastAssignees == null) {
            return Response.ok(Collections.emptyList());
        }
        AccountLoader accountLoader = this.accountLoaderFactory.create(true);
        List infos = pastAssignees.stream().map(accountLoader::get).collect(Collectors.toList());
        accountLoader.fill();
        return Response.ok(infos);
    }
}

