/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalCopier;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.extensions.events.RevisionCreated;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.mail.send.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchSetInserter
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(PatchSetInserter.class);
    private final PermissionBackend permissionBackend;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;
    private final ProjectCache projectCache;
    private final RevisionCreated revisionCreated;
    private final ApprovalsUtil approvalsUtil;
    private final ApprovalCopier approvalCopier;
    private final ChangeMessagesUtil cmUtil;
    private final PatchSetUtil psUtil;
    private final PatchSet.Id psId;
    private final ObjectId commitId;
    private final ChangeNotes origNotes;
    private String message;
    private String description;
    private boolean validate = true;
    private boolean checkAddPatchSetPermission = true;
    private List<String> groups = Collections.emptyList();
    private boolean fireRevisionCreated = true;
    private NotifyHandling notify = NotifyHandling.ALL;
    private ListMultimap<RecipientType, Account.Id> accountsToNotify = ImmutableListMultimap.of();
    private boolean allowClosed;
    private boolean copyApprovals = true;
    private Change change;
    private PatchSet patchSet;
    private PatchSetInfo patchSetInfo;
    private ChangeMessage changeMessage;
    private ReviewerSet oldReviewers;

    @Inject
    public PatchSetInserter(PermissionBackend permissionBackend, ApprovalsUtil approvalsUtil, ApprovalCopier approvalCopier, ChangeMessagesUtil cmUtil, PatchSetInfoFactory patchSetInfoFactory, CommitValidators.Factory commitValidatorsFactory, ReplacePatchSetSender.Factory replacePatchSetFactory, PatchSetUtil psUtil, RevisionCreated revisionCreated, ProjectCache projectCache, @Assisted ChangeNotes notes, @Assisted PatchSet.Id psId, @Assisted ObjectId commitId) {
        this.permissionBackend = permissionBackend;
        this.approvalsUtil = approvalsUtil;
        this.approvalCopier = approvalCopier;
        this.cmUtil = cmUtil;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.replacePatchSetFactory = replacePatchSetFactory;
        this.psUtil = psUtil;
        this.revisionCreated = revisionCreated;
        this.projectCache = projectCache;
        this.origNotes = notes;
        this.psId = psId;
        this.commitId = commitId.copy();
    }

    public PatchSet.Id getPatchSetId() {
        return this.psId;
    }

    public PatchSetInserter setMessage(String message) {
        this.message = message;
        return this;
    }

    public PatchSetInserter setDescription(String description) {
        this.description = description;
        return this;
    }

    public PatchSetInserter setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public PatchSetInserter setCheckAddPatchSetPermission(boolean checkAddPatchSetPermission) {
        this.checkAddPatchSetPermission = checkAddPatchSetPermission;
        return this;
    }

    public PatchSetInserter setGroups(List<String> groups) {
        Preconditions.checkNotNull(groups, "groups may not be null");
        this.groups = groups;
        return this;
    }

    public PatchSetInserter setFireRevisionCreated(boolean fireRevisionCreated) {
        this.fireRevisionCreated = fireRevisionCreated;
        return this;
    }

    public PatchSetInserter setNotify(NotifyHandling notify) {
        this.notify = Preconditions.checkNotNull(notify);
        return this;
    }

    public PatchSetInserter setAccountsToNotify(ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.accountsToNotify = Preconditions.checkNotNull(accountsToNotify);
        return this;
    }

    public PatchSetInserter setAllowClosed(boolean allowClosed) {
        this.allowClosed = allowClosed;
        return this;
    }

    public PatchSetInserter setCopyApprovals(boolean copyApprovals) {
        this.copyApprovals = copyApprovals;
        return this;
    }

    public Change getChange() {
        Preconditions.checkState(this.change != null, "getChange() only valid after executing update");
        return this.change;
    }

    public PatchSet getPatchSet() {
        Preconditions.checkState(this.patchSet != null, "getPatchSet() only valid after executing update");
        return this.patchSet;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws AuthException, ResourceConflictException, IOException, OrmException, PermissionBackendException {
        this.validate(ctx);
        ctx.addRefUpdate(ObjectId.zeroId(), this.commitId, this.getPatchSetId().toRefName());
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws ResourceConflictException, OrmException, IOException {
        PatchSet prevPs;
        ReviewDb db = ctx.getDb();
        this.change = ctx.getChange();
        ChangeUpdate update = ctx.getUpdate(this.psId);
        update.setSubjectForCommit("Create patch set " + this.psId.get());
        if (!this.change.getStatus().isOpen() && !this.allowClosed) {
            throw new ResourceConflictException(String.format("Cannot create new patch set of change %s because it is %s", this.change.getId(), ChangeUtil.status(this.change)));
        }
        List<String> newGroups = this.groups;
        if (newGroups.isEmpty() && (prevPs = this.psUtil.current(db, ctx.getNotes())) != null) {
            newGroups = prevPs.getGroups();
        }
        this.patchSet = this.psUtil.insert(db, ctx.getRevWalk(), ctx.getUpdate(this.psId), this.psId, this.commitId, newGroups, null, this.description);
        if (this.notify != NotifyHandling.NONE) {
            this.oldReviewers = this.approvalsUtil.getReviewers(db, ctx.getNotes());
        }
        if (this.message != null) {
            this.changeMessage = ChangeMessagesUtil.newMessage(this.patchSet.getId(), ctx.getUser(), ctx.getWhen(), this.message, ChangeMessagesUtil.uploadedPatchSetTag(this.change.isWorkInProgress()));
            this.changeMessage.setMessage(this.message);
        }
        this.patchSetInfo = this.patchSetInfoFactory.get(ctx.getRevWalk(), ctx.getRevWalk().parseCommit(this.commitId), this.psId);
        if (!this.allowClosed) {
            this.change.setStatus(Change.Status.NEW);
        }
        this.change.setCurrentPatchSet(this.patchSetInfo);
        if (this.copyApprovals) {
            this.approvalCopier.copyInReviewDb(db, ctx.getNotes(), ctx.getUser(), this.patchSet, ctx.getRevWalk(), ctx.getRepoView().getConfig());
        }
        if (this.changeMessage != null) {
            this.cmUtil.addChangeMessage(db, update, this.changeMessage);
        }
        return true;
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        if (this.notify != NotifyHandling.NONE || !this.accountsToNotify.isEmpty()) {
            try {
                ReplacePatchSetSender cm = this.replacePatchSetFactory.create(ctx.getProject(), this.change.getId());
                cm.setFrom(ctx.getAccountId());
                cm.setPatchSet(this.patchSet, this.patchSetInfo);
                cm.setChangeMessage(this.changeMessage.getMessage(), ctx.getWhen());
                cm.addReviewers(this.oldReviewers.byState(ReviewerStateInternal.REVIEWER));
                cm.addExtraCC(this.oldReviewers.byState(ReviewerStateInternal.CC));
                cm.setNotify(this.notify);
                cm.setAccountsToNotify(this.accountsToNotify);
                cm.send();
            }
            catch (Exception err) {
                log.error("Cannot send email for new patch set on change " + this.change.getId(), err);
            }
        }
        if (this.fireRevisionCreated) {
            this.revisionCreated.fire(this.change, this.patchSet, ctx.getAccount(), ctx.getWhen(), this.notify);
        }
    }

    private void validate(RepoContext ctx) throws AuthException, ResourceConflictException, IOException, PermissionBackendException {
        if (this.checkAddPatchSetPermission) {
            ((PermissionBackend.WithUser)this.permissionBackend.user(ctx.getUser()).database(ctx.getDb())).change(this.origNotes).check(ChangePermission.ADD_PATCH_SET);
        }
        if (!this.validate) {
            return;
        }
        PermissionBackend.ForRef perm = this.permissionBackend.user(ctx.getUser()).ref(this.origNotes.getChange().getDest());
        String refName = this.getPatchSetId().toRefName();
        try (CommitReceivedEvent event = new CommitReceivedEvent(new ReceiveCommand(ObjectId.zeroId(), this.commitId, refName.substring(0, refName.lastIndexOf(47) + 1) + "new"), this.projectCache.checkedGet(this.origNotes.getProjectName()).getProject(), this.origNotes.getChange().getDest().get(), ctx.getRevWalk().getObjectReader(), this.commitId, ctx.getIdentifiedUser());){
            this.commitValidatorsFactory.forGerritCommits(perm, this.origNotes.getChange().getDest(), ctx.getIdentifiedUser(), new NoSshInfo(), ctx.getRevWalk()).validate(event);
        }
        catch (CommitValidationException e) {
            throw new ResourceConflictException(e.getFullMessage());
        }
    }

    public static interface Factory {
        public PatchSetInserter create(ChangeNotes var1, PatchSet.Id var2, ObjectId var3);
    }
}

