/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSortedSet;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.SetHashtagsOp;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class PostHashtags
extends RetryingRestModifyView<ChangeResource, HashtagsInput, Response<ImmutableSortedSet<String>>>
implements UiAction<ChangeResource> {
    private final Provider<ReviewDb> db;
    private final SetHashtagsOp.Factory hashtagsFactory;

    @Inject
    PostHashtags(Provider<ReviewDb> db, RetryHelper retryHelper, SetHashtagsOp.Factory hashtagsFactory) {
        super(retryHelper);
        this.db = db;
        this.hashtagsFactory = hashtagsFactory;
    }

    @Override
    protected Response<ImmutableSortedSet<String>> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource req, HashtagsInput input) throws RestApiException, UpdateException, PermissionBackendException {
        req.permissions().check(ChangePermission.EDIT_HASHTAGS);
        try (BatchUpdate bu = updateFactory.create(this.db.get(), req.getChange().getProject(), req.getUser(), TimeUtil.nowTs());){
            SetHashtagsOp op = this.hashtagsFactory.create(input);
            bu.addOp(req.getId(), op);
            bu.execute();
            Response<ImmutableSortedSet<String>> response = Response.ok(op.getUpdatedHashtags());
            return response;
        }
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        return new UiAction.Description().setLabel("Edit Hashtags").setVisible(rsrc.permissions().testCond(ChangePermission.EDIT_HASHTAGS));
    }
}

