/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.ProjectUtil;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ChangeSet;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeSuperSet;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Submit
implements RestModifyView<RevisionResource, SubmitInput>,
UiAction<RevisionResource> {
    private static final Logger log = LoggerFactory.getLogger(Submit.class);
    private static final String DEFAULT_TOOLTIP = "Submit patch set ${patchSet} into ${branch}";
    private static final String DEFAULT_TOOLTIP_ANCESTORS = "Submit patch set ${patchSet} and ancestors (${submitSize} changes altogether) into ${branch}";
    private static final String DEFAULT_TOPIC_TOOLTIP = "Submit all ${topicSize} changes of the same topic (${submitSize} changes including ancestors and other changes related by topic)";
    private static final String BLOCKED_SUBMIT_TOOLTIP = "This change depends on other changes which are not ready";
    private static final String BLOCKED_HIDDEN_SUBMIT_TOOLTIP = "This change depends on other hidden changes which are not ready";
    private static final String BLOCKED_WORK_IN_PROGRESS = "This change is marked work in progress";
    private static final String CLICK_FAILURE_TOOLTIP = "Clicking the button would fail";
    private static final String CHANGE_UNMERGEABLE = "Problems with integrating this change";
    private static final String CHANGES_NOT_MERGEABLE = "Problems with change(s): ";
    private final Provider<ReviewDb> dbProvider;
    private final GitRepositoryManager repoManager;
    private final PermissionBackend permissionBackend;
    private final ChangeData.Factory changeDataFactory;
    private final ChangeMessagesUtil cmUtil;
    private final ChangeNotes.Factory changeNotesFactory;
    private final Provider<MergeOp> mergeOpProvider;
    private final Provider<MergeSuperSet> mergeSuperSet;
    private final AccountsCollection accounts;
    private final String label;
    private final String labelWithParents;
    private final ParameterizedString titlePattern;
    private final ParameterizedString titlePatternWithAncestors;
    private final String submitTopicLabel;
    private final ParameterizedString submitTopicTooltip;
    private final boolean submitWholeTopic;
    private final Provider<InternalChangeQuery> queryProvider;
    private final PatchSetUtil psUtil;

    @Inject
    Submit(Provider<ReviewDb> dbProvider, GitRepositoryManager repoManager, PermissionBackend permissionBackend, ChangeData.Factory changeDataFactory, ChangeMessagesUtil cmUtil, ChangeNotes.Factory changeNotesFactory, Provider<MergeOp> mergeOpProvider, Provider<MergeSuperSet> mergeSuperSet, AccountsCollection accounts, @GerritServerConfig Config cfg, Provider<InternalChangeQuery> queryProvider, PatchSetUtil psUtil) {
        this.dbProvider = dbProvider;
        this.repoManager = repoManager;
        this.permissionBackend = permissionBackend;
        this.changeDataFactory = changeDataFactory;
        this.cmUtil = cmUtil;
        this.changeNotesFactory = changeNotesFactory;
        this.mergeOpProvider = mergeOpProvider;
        this.mergeSuperSet = mergeSuperSet;
        this.accounts = accounts;
        this.label = MoreObjects.firstNonNull(Strings.emptyToNull(cfg.getString("change", null, "submitLabel")), "Submit");
        this.labelWithParents = MoreObjects.firstNonNull(Strings.emptyToNull(cfg.getString("change", null, "submitLabelWithParents")), "Submit including parents");
        this.titlePattern = new ParameterizedString(MoreObjects.firstNonNull(cfg.getString("change", null, "submitTooltip"), DEFAULT_TOOLTIP));
        this.titlePatternWithAncestors = new ParameterizedString(MoreObjects.firstNonNull(cfg.getString("change", null, "submitTooltipAncestors"), DEFAULT_TOOLTIP_ANCESTORS));
        this.submitWholeTopic = Submit.wholeTopicEnabled(cfg);
        this.submitTopicLabel = MoreObjects.firstNonNull(Strings.emptyToNull(cfg.getString("change", null, "submitTopicLabel")), "Submit whole topic");
        this.submitTopicTooltip = new ParameterizedString(MoreObjects.firstNonNull(cfg.getString("change", null, "submitTopicTooltip"), DEFAULT_TOPIC_TOOLTIP));
        this.queryProvider = queryProvider;
        this.psUtil = psUtil;
    }

    public Output apply(RevisionResource rsrc, SubmitInput input) throws RestApiException, RepositoryNotFoundException, IOException, OrmException, PermissionBackendException, UpdateException, ConfigInvalidException {
        IdentifiedUser submitter;
        input.onBehalfOf = Strings.emptyToNull(input.onBehalfOf);
        if (input.onBehalfOf != null) {
            submitter = this.onBehalfOf(rsrc, input);
        } else {
            rsrc.permissions().check(ChangePermission.SUBMIT);
            submitter = rsrc.getUser().asIdentifiedUser();
        }
        return new Output(this.mergeChange(rsrc, submitter, input));
    }

    public Change mergeChange(RevisionResource rsrc, IdentifiedUser submitter, SubmitInput input) throws OrmException, RestApiException, IOException, UpdateException, ConfigInvalidException, PermissionBackendException {
        Change change = rsrc.getChange();
        if (!change.getStatus().isOpen()) {
            throw new ResourceConflictException("change is " + ChangeUtil.status(change));
        }
        if (!ProjectUtil.branchExists(this.repoManager, change.getDest())) {
            throw new ResourceConflictException(String.format("destination branch \"%s\" not found.", change.getDest().get()));
        }
        if (!rsrc.getPatchSet().getId().equals(change.currentPatchSetId())) {
            throw new ResourceConflictException(String.format("revision %s is not current revision", rsrc.getPatchSet().getRevision().get()));
        }
        try (MergeOp op = this.mergeOpProvider.get();){
            ReviewDb db = this.dbProvider.get();
            op.merge(db, change, submitter, true, input, false);
            try {
                change = this.changeNotesFactory.createChecked(db, change.getProject(), change.getId()).getChange();
            }
            catch (NoSuchChangeException e) {
                throw new ResourceConflictException("change is deleted");
            }
        }
        switch (change.getStatus()) {
            case MERGED: {
                return change;
            }
            case NEW: {
                ChangeMessage msg = this.getConflictMessage(rsrc);
                if (msg == null) break;
                throw new ResourceConflictException(msg.getMessage());
            }
        }
        throw new ResourceConflictException("change is " + ChangeUtil.status(change));
    }

    private String problemsForSubmittingChangeset(ChangeData cd, ChangeSet cs, CurrentUser user) {
        try {
            if (cs.furtherHiddenChanges()) {
                return BLOCKED_HIDDEN_SUBMIT_TOOLTIP;
            }
            for (ChangeData c2 : cs.changes()) {
                Set<ChangePermission> can = ((PermissionBackend.WithUser)this.permissionBackend.user(user).database(this.dbProvider)).change(c2).test(EnumSet.of(ChangePermission.READ, ChangePermission.SUBMIT));
                if (!can.contains(ChangePermission.READ)) {
                    return BLOCKED_HIDDEN_SUBMIT_TOOLTIP;
                }
                if (!can.contains(ChangePermission.SUBMIT)) {
                    return BLOCKED_SUBMIT_TOOLTIP;
                }
                if (c2.change().isWorkInProgress()) {
                    return BLOCKED_WORK_IN_PROGRESS;
                }
                MergeOp.checkSubmitRule(c2, false);
            }
            Collection<ChangeData> unmergeable = this.unmergeableChanges(cs);
            if (unmergeable == null) {
                return CLICK_FAILURE_TOOLTIP;
            }
            if (!unmergeable.isEmpty()) {
                for (ChangeData c3 : unmergeable) {
                    if (!c3.change().getKey().equals(cd.change().getKey())) continue;
                    return CHANGE_UNMERGEABLE;
                }
                return CHANGES_NOT_MERGEABLE + unmergeable.stream().map(c -> c.getId().toString()).collect(Collectors.joining(", "));
            }
        }
        catch (ResourceConflictException e) {
            return BLOCKED_SUBMIT_TOOLTIP;
        }
        catch (PermissionBackendException | OrmException | IOException e) {
            log.error("Error checking if change is submittable", e);
            throw new OrmRuntimeException("Could not determine problems for the change", e);
        }
        return null;
    }

    @Override
    public UiAction.Description getDescription(RevisionResource resource) {
        Boolean enabled;
        ChangeSet cs;
        Change change = resource.getChange();
        if (!(change.getStatus().isOpen() && resource.isCurrent() && resource.permissions().testOrFalse(ChangePermission.SUBMIT))) {
            return null;
        }
        ReviewDb db = this.dbProvider.get();
        ChangeData cd = this.changeDataFactory.create(db, resource.getNotes());
        try {
            MergeOp.checkSubmitRule(cd, false);
        }
        catch (ResourceConflictException e) {
            return null;
        }
        catch (OrmException e) {
            log.error("Error checking if change is submittable", e);
            throw new OrmRuntimeException("Could not determine problems for the change", e);
        }
        try {
            cs = this.mergeSuperSet.get().completeChangeSet(db, cd.change(), resource.getUser());
        }
        catch (PermissionBackendException | OrmException | IOException e) {
            throw new OrmRuntimeException("Could not determine complete set of changes to be submitted", e);
        }
        String topic = change.getTopic();
        int topicSize = 0;
        if (!Strings.isNullOrEmpty(topic)) {
            topicSize = this.getChangesByTopic(topic).size();
        }
        boolean treatWithTopic = this.submitWholeTopic && !Strings.isNullOrEmpty(topic) && topicSize > 1;
        String submitProblems = this.problemsForSubmittingChangeset(cd, cs, resource.getUser());
        try {
            enabled = cd.isMergeable();
        }
        catch (OrmException e) {
            throw new OrmRuntimeException("Could not determine mergeability", e);
        }
        if (submitProblems != null) {
            return new UiAction.Description().setLabel(treatWithTopic ? this.submitTopicLabel : (cs.size() > 1 ? this.labelWithParents : this.label)).setTitle(submitProblems).setVisible(true).setEnabled(false);
        }
        if (treatWithTopic) {
            ImmutableMap<String, String> params = ImmutableMap.of("topicSize", String.valueOf(topicSize), "submitSize", String.valueOf(cs.size()));
            return new UiAction.Description().setLabel(this.submitTopicLabel).setTitle(Strings.emptyToNull(this.submitTopicTooltip.replace(params))).setVisible(true).setEnabled(Boolean.TRUE.equals(enabled));
        }
        RevId revId = resource.getPatchSet().getRevision();
        ImmutableMap<String, String> params = ImmutableMap.of("patchSet", String.valueOf(resource.getPatchSet().getPatchSetId()), "branch", change.getDest().getShortName(), "commit", ObjectId.fromString(revId.get()).abbreviate(7).name(), "submitSize", String.valueOf(cs.size()));
        ParameterizedString tp = cs.size() > 1 ? this.titlePatternWithAncestors : this.titlePattern;
        return new UiAction.Description().setLabel(cs.size() > 1 ? this.labelWithParents : this.label).setTitle(Strings.emptyToNull(tp.replace(params))).setVisible(true).setEnabled(Boolean.TRUE.equals(enabled));
    }

    public ChangeMessage getConflictMessage(RevisionResource rsrc) throws OrmException {
        return FluentIterable.from(this.cmUtil.byPatchSet(this.dbProvider.get(), rsrc.getNotes(), rsrc.getPatchSet().getId())).filter(cm -> cm.getAuthor() == null).last().orNull();
    }

    public Collection<ChangeData> unmergeableChanges(ChangeSet cs) throws OrmException, IOException {
        HashSet<ChangeData> mergeabilityMap = new HashSet<ChangeData>();
        for (ChangeData change : cs.changes()) {
            mergeabilityMap.add(change);
        }
        ListMultimap<Branch.NameKey, ChangeData> cbb = cs.changesByBranch();
        block1: for (Branch.NameKey branch : cbb.keySet()) {
            Collection targetBranch = cbb.get((Object)branch);
            HashMap<Change.Id, RevCommit> commits = this.findCommits(targetBranch, branch.getParentKey());
            HashSet<ObjectId> allParents = Sets.newHashSetWithExpectedSize(cs.size());
            for (RevCommit commit : commits.values()) {
                for (RevCommit parent : commit.getParents()) {
                    allParents.add(parent.getId());
                }
            }
            for (ChangeData change : targetBranch) {
                RevCommit commit = commits.get(change.getId());
                boolean isMergeCommit = commit.getParentCount() > 1;
                boolean isLastInChain = !allParents.contains(commit.getId());
                change.setMergeable(null);
                Boolean mergeable = change.isMergeable();
                if (mergeable == null) {
                    return null;
                }
                if (mergeable.booleanValue()) {
                    mergeabilityMap.remove(change);
                }
                if (!isLastInChain || !isMergeCommit || !mergeable.booleanValue()) continue;
                for (ChangeData c : targetBranch) {
                    mergeabilityMap.remove(c);
                }
                continue block1;
            }
        }
        return mergeabilityMap;
    }

    private HashMap<Change.Id, RevCommit> findCommits(Collection<ChangeData> changes, Project.NameKey project) throws IOException, OrmException {
        HashMap<Change.Id, RevCommit> commits = new HashMap<Change.Id, RevCommit>();
        try (Repository repo = this.repoManager.openRepository(project);
             RevWalk walk = new RevWalk(repo);){
            for (ChangeData change : changes) {
                RevCommit commit = walk.parseCommit(ObjectId.fromString(this.psUtil.current(this.dbProvider.get(), change.notes()).getRevision().get()));
                commits.put(change.getId(), commit);
            }
        }
        return commits;
    }

    private IdentifiedUser onBehalfOf(RevisionResource rsrc, SubmitInput in) throws AuthException, UnprocessableEntityException, OrmException, PermissionBackendException, IOException, ConfigInvalidException {
        PermissionBackend.ForChange perm = (PermissionBackend.ForChange)rsrc.permissions().database(this.dbProvider);
        perm.check(ChangePermission.SUBMIT);
        perm.check(ChangePermission.SUBMIT_AS);
        CurrentUser caller = rsrc.getUser();
        IdentifiedUser submitter = this.accounts.parseOnBehalfOf(caller, in.onBehalfOf);
        try {
            perm.user(submitter).check(ChangePermission.READ);
        }
        catch (AuthException e) {
            throw new UnprocessableEntityException(String.format("on_behalf_of account %s cannot see change", submitter.getAccountId()));
        }
        return submitter;
    }

    public static boolean wholeTopicEnabled(Config config) {
        return config.getBoolean("change", null, "submitWholeTopic", false);
    }

    private List<ChangeData> getChangesByTopic(String topic) {
        try {
            return this.queryProvider.get().byTopicOpen(topic);
        }
        catch (OrmException e) {
            throw new OrmRuntimeException(e);
        }
    }

    public static class CurrentRevision
    implements RestModifyView<ChangeResource, SubmitInput> {
        private final Provider<ReviewDb> dbProvider;
        private final Submit submit;
        private final ChangeJson.Factory json;
        private final PatchSetUtil psUtil;

        @Inject
        CurrentRevision(Provider<ReviewDb> dbProvider, Submit submit, ChangeJson.Factory json, PatchSetUtil psUtil) {
            this.dbProvider = dbProvider;
            this.submit = submit;
            this.json = json;
            this.psUtil = psUtil;
        }

        public ChangeInfo apply(ChangeResource rsrc, SubmitInput input) throws RestApiException, RepositoryNotFoundException, IOException, OrmException, PermissionBackendException, UpdateException, ConfigInvalidException {
            PatchSet ps = this.psUtil.current(this.dbProvider.get(), rsrc.getNotes());
            if (ps == null) {
                throw new ResourceConflictException("current revision is missing");
            }
            Output out = this.submit.apply(new RevisionResource(rsrc, ps), input);
            return this.json.noOptions().format(out.change);
        }
    }

    @VisibleForTesting
    public static class TestSubmitInput
    extends SubmitInput {
        public boolean failAfterRefUpdates;
        public Queue<Boolean> generateLockFailures;
    }

    public static class Output {
        transient Change change;

        private Output(Change c) {
            this.change = c;
        }
    }
}

