/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.config.GerritConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritServerConfigProvider
implements Provider<Config> {
    private static final Logger log = LoggerFactory.getLogger(GerritServerConfigProvider.class);
    private final SitePaths site;
    private final SecureStore secureStore;

    @Inject
    GerritServerConfigProvider(SitePaths site, SecureStore secureStore) {
        this.site = site;
        this.secureStore = secureStore;
    }

    @Override
    public Config get() {
        FileBasedConfig baseConfig = GerritServerConfigProvider.loadConfig(null, this.site.gerrit_config);
        if (!baseConfig.getFile().exists()) {
            log.info("No " + this.site.gerrit_config.toAbsolutePath() + "; assuming defaults");
        }
        FileBasedConfig noteDbConfigOverBaseConfig = GerritServerConfigProvider.loadConfig(baseConfig, this.site.notedb_config);
        GerritServerConfigProvider.checkNoteDbConfig(noteDbConfigOverBaseConfig);
        return new GerritConfig(noteDbConfigOverBaseConfig, baseConfig, this.secureStore);
    }

    private static FileBasedConfig loadConfig(@Nullable Config base, Path path) {
        FileBasedConfig cfg = new FileBasedConfig(base, path.toFile(), FS.DETECTED);
        try {
            cfg.load();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new ProvisionException(e.getMessage(), e);
        }
        return cfg;
    }

    private static void checkNoteDbConfig(FileBasedConfig noteDbConfig) {
        ArrayList bad = new ArrayList();
        for (String section : noteDbConfig.getSections()) {
            if (section.equals("noteDb")) continue;
            for (String subsection : noteDbConfig.getSubsections(section)) {
                noteDbConfig.getNames(section, subsection, false).forEach(n -> bad.add(section + "." + subsection + "." + n));
            }
            noteDbConfig.getNames(section, false).forEach(n -> bad.add(section + "." + n));
        }
        if (!bad.isEmpty()) {
            throw new ProvisionException("Non-NoteDb config options not allowed in " + noteDbConfig.getFile() + ":\n" + bad.stream().collect(Collectors.joining("\n")));
        }
    }
}

