/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Config;

@Singleton
public class RepositoryConfig {
    static final String SECTION_NAME = "repository";
    static final String OWNER_GROUP_NAME = "ownerGroup";
    static final String DEFAULT_SUBMIT_TYPE_NAME = "defaultSubmitType";
    static final String BASE_PATH_NAME = "basePath";
    private final Config cfg;

    @Inject
    public RepositoryConfig(@GerritServerConfig Config cfg) {
        this.cfg = cfg;
    }

    public SubmitType getDefaultSubmitType(Project.NameKey project) {
        return this.cfg.getEnum(SECTION_NAME, this.findSubSection(project.get()), DEFAULT_SUBMIT_TYPE_NAME, SubmitType.MERGE_IF_NECESSARY);
    }

    public List<String> getOwnerGroups(Project.NameKey project) {
        return ImmutableList.copyOf(this.cfg.getStringList(SECTION_NAME, this.findSubSection(project.get()), OWNER_GROUP_NAME));
    }

    public Path getBasePath(Project.NameKey project) {
        String basePath = this.cfg.getString(SECTION_NAME, this.findSubSection(project.get()), BASE_PATH_NAME);
        return basePath != null ? Paths.get(basePath, new String[0]) : null;
    }

    public List<Path> getAllBasePaths() {
        ArrayList<Path> basePaths = new ArrayList<Path>();
        for (String subSection : this.cfg.getSubsections(SECTION_NAME)) {
            String basePath = this.cfg.getString(SECTION_NAME, subSection, BASE_PATH_NAME);
            if (basePath == null) continue;
            basePaths.add(Paths.get(basePath, new String[0]));
        }
        return basePaths;
    }

    private String findSubSection(String project) {
        String subSectionFound = null;
        for (String subSection : this.cfg.getSubsections(SECTION_NAME)) {
            if (!this.isMatch(subSection, project) || subSectionFound != null && subSectionFound.length() >= subSection.length()) continue;
            subSectionFound = subSection;
        }
        return subSectionFound;
    }

    private boolean isMatch(String subSection, String project) {
        return project.equals(subSection) || subSection.endsWith("*") && project.startsWith(subSection.substring(0, subSection.length() - 1));
    }
}

