/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.CommentAddedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.extensions.events.AbstractRevisionEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchListObjectTooLargeException;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CommentAdded {
    private static final Logger log = LoggerFactory.getLogger(CommentAdded.class);
    private final DynamicSet<CommentAddedListener> listeners;
    private final EventUtil util;

    @Inject
    CommentAdded(DynamicSet<CommentAddedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, PatchSet ps, Account author, String comment, Map<String, Short> approvals, Map<String, Short> oldApprovals, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.revisionInfo(change.getProject(), ps), this.util.accountInfo(author), comment, this.util.approvals(author, approvals, when), this.util.approvals(author, oldApprovals, when), when);
            for (CommentAddedListener l : this.listeners) {
                try {
                    l.onCommentAdded(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (PatchListObjectTooLargeException e) {
            log.warn("Couldn't fire event: " + e.getMessage());
        }
        catch (GpgException | PatchListNotAvailableException | PermissionBackendException | OrmException | IOException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractRevisionEvent
    implements CommentAddedListener.Event {
        private final String comment;
        private final Map<String, ApprovalInfo> approvals;
        private final Map<String, ApprovalInfo> oldApprovals;

        Event(ChangeInfo change, RevisionInfo revision, AccountInfo author, String comment, Map<String, ApprovalInfo> approvals, Map<String, ApprovalInfo> oldApprovals, Timestamp when) {
            super(change, revision, author, when, NotifyHandling.ALL);
            this.comment = comment;
            this.approvals = approvals;
            this.oldApprovals = oldApprovals;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public Map<String, ApprovalInfo> getApprovals() {
            return this.approvals;
        }

        @Override
        public Map<String, ApprovalInfo> getOldApprovals() {
            return this.oldApprovals;
        }
    }
}

