/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.PrivateStateChangedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.extensions.events.AbstractRevisionEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PrivateStateChanged {
    private static final Logger log = LoggerFactory.getLogger(PrivateStateChanged.class);
    private final DynamicSet<PrivateStateChangedListener> listeners;
    private final EventUtil util;

    @Inject
    PrivateStateChanged(DynamicSet<PrivateStateChangedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, PatchSet patchSet, Account account, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.revisionInfo(change.getProject(), patchSet), this.util.accountInfo(account), when);
            for (PrivateStateChangedListener l : this.listeners) {
                try {
                    l.onPrivateStateChanged(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(event, l, e);
                }
            }
        }
        catch (GpgException | PatchListNotAvailableException | PermissionBackendException | OrmException | IOException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractRevisionEvent
    implements PrivateStateChangedListener.Event {
        protected Event(ChangeInfo change, RevisionInfo revision, AccountInfo who, Timestamp when) {
            super(change, revision, who, when, NotifyHandling.ALL);
        }
    }
}

