/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.VoteDeletedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.extensions.events.AbstractRevisionEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchListObjectTooLargeException;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VoteDeleted {
    private static final Logger log = LoggerFactory.getLogger(VoteDeleted.class);
    private final DynamicSet<VoteDeletedListener> listeners;
    private final EventUtil util;

    @Inject
    VoteDeleted(DynamicSet<VoteDeletedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, PatchSet ps, Account reviewer, Map<String, Short> approvals, Map<String, Short> oldApprovals, NotifyHandling notify, String message, Account remover, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.revisionInfo(change.getProject(), ps), this.util.accountInfo(reviewer), this.util.approvals(remover, approvals, when), this.util.approvals(remover, oldApprovals, when), notify, message, this.util.accountInfo(remover), when);
            for (VoteDeletedListener l : this.listeners) {
                try {
                    l.onVoteDeleted(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (PatchListObjectTooLargeException e) {
            log.warn("Couldn't fire event: " + e.getMessage());
        }
        catch (GpgException | PatchListNotAvailableException | PermissionBackendException | OrmException | IOException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractRevisionEvent
    implements VoteDeletedListener.Event {
        private final AccountInfo reviewer;
        private final Map<String, ApprovalInfo> approvals;
        private final Map<String, ApprovalInfo> oldApprovals;
        private final String message;

        Event(ChangeInfo change, RevisionInfo revision, AccountInfo reviewer, Map<String, ApprovalInfo> approvals, Map<String, ApprovalInfo> oldApprovals, NotifyHandling notify, String message, AccountInfo remover, Timestamp when) {
            super(change, revision, remover, when, notify);
            this.reviewer = reviewer;
            this.approvals = approvals;
            this.oldApprovals = oldApprovals;
            this.message = message;
        }

        @Override
        public Map<String, ApprovalInfo> getApprovals() {
            return this.approvals;
        }

        @Override
        public Map<String, ApprovalInfo> getOldApprovals() {
            return this.oldApprovals;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public AccountInfo getReviewer() {
            return this.reviewer;
        }
    }
}

