/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ChangeSet {
    private final ImmutableMap<Change.Id, ChangeData> changeData;
    private final ImmutableMap<Change.Id, ChangeData> nonVisibleChanges;

    private static ImmutableMap<Change.Id, ChangeData> index(Iterable<ChangeData> changes, Collection<Change.Id> exclude) {
        LinkedHashMap<Change.Id, ChangeData> ret = new LinkedHashMap<Change.Id, ChangeData>();
        for (ChangeData cd : changes) {
            Change.Id id = cd.getId();
            if (ret.containsKey(id) || exclude.contains(id)) continue;
            ret.put(id, cd);
        }
        return ImmutableMap.copyOf(ret);
    }

    public ChangeSet(Iterable<ChangeData> changes, Iterable<ChangeData> hiddenChanges) {
        this.changeData = ChangeSet.index(changes, ImmutableList.of());
        this.nonVisibleChanges = ChangeSet.index(hiddenChanges, this.changeData.keySet());
    }

    public ChangeSet(ChangeData change, boolean visible) {
        this(visible ? ImmutableList.of(change) : ImmutableList.of(), ImmutableList.of(change));
    }

    public ImmutableSet<Change.Id> ids() {
        return this.changeData.keySet();
    }

    public ImmutableMap<Change.Id, ChangeData> changesById() {
        return this.changeData;
    }

    public ListMultimap<Branch.NameKey, ChangeData> changesByBranch() throws OrmException {
        Multimap ret = MultimapBuilder.hashKeys().arrayListValues().build();
        for (ChangeData cd : this.changeData.values()) {
            ret.put(cd.change().getDest(), cd);
        }
        return ret;
    }

    public ImmutableCollection<ChangeData> changes() {
        return this.changeData.values();
    }

    public ImmutableSet<Project.NameKey> projects() {
        ImmutableSet.Builder ret = ImmutableSet.builder();
        for (ChangeData cd : this.changeData.values()) {
            ret.add(cd.project());
        }
        return ret.build();
    }

    public ImmutableSet<Change.Id> nonVisibleIds() {
        return this.nonVisibleChanges.keySet();
    }

    public ImmutableList<ChangeData> nonVisibleChanges() {
        return ((ImmutableCollection)this.nonVisibleChanges.values()).asList();
    }

    public boolean furtherHiddenChanges() {
        return !this.nonVisibleChanges.isEmpty();
    }

    public int size() {
        return this.changeData.size() + this.nonVisibleChanges.size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.ids() + this.nonVisibleIds();
    }
}

