/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.server.ApprovalCopier;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.change.EmailReviewComments;
import com.google.gerrit.server.extensions.events.CommentAdded;
import com.google.gerrit.server.extensions.events.RevisionCreated;
import com.google.gerrit.server.git.MergedByPushOp;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.git.receive.ReceiveCommits;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.send.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(ReplaceOp.class);
    private static final String CHANGE_IS_CLOSED = "change is closed";
    private final AccountResolver accountResolver;
    private final ApprovalCopier approvalCopier;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeData.Factory changeDataFactory;
    private final ChangeKindCache changeKindCache;
    private final ChangeMessagesUtil cmUtil;
    private final CommentsUtil commentsUtil;
    private final EmailReviewComments.Factory emailCommentsFactory;
    private final ExecutorService sendEmailExecutor;
    private final RevisionCreated revisionCreated;
    private final CommentAdded commentAdded;
    private final MergedByPushOp.Factory mergedByPushOpFactory;
    private final PatchSetUtil psUtil;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;
    private final ProjectCache projectCache;
    private final ProjectControl projectControl;
    private final Branch.NameKey dest;
    private final boolean checkMergedInto;
    private final PatchSet.Id priorPatchSetId;
    private final ObjectId priorCommitId;
    private final PatchSet.Id patchSetId;
    private final ObjectId commitId;
    private final PatchSetInfo info;
    private final ReceiveCommits.MagicBranchInput magicBranch;
    private final PushCertificate pushCertificate;
    private List<String> groups = ImmutableList.of();
    private final Map<String, Short> approvals = new HashMap<String, Short>();
    private final MailUtil.MailRecipients recipients = new MailUtil.MailRecipients();
    private RevCommit commit;
    private ReceiveCommand cmd;
    private ChangeNotes notes;
    private PatchSet newPatchSet;
    private ChangeKind changeKind;
    private ChangeMessage msg;
    private List<Comment> comments = ImmutableList.of();
    private String rejectMessage;
    private MergedByPushOp mergedByPushOp;
    private RequestScopePropagator requestScopePropagator;

    @Inject
    ReplaceOp(AccountResolver accountResolver, ApprovalCopier approvalCopier, ApprovalsUtil approvalsUtil, ChangeData.Factory changeDataFactory, ChangeKindCache changeKindCache, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, EmailReviewComments.Factory emailCommentsFactory, RevisionCreated revisionCreated, CommentAdded commentAdded, MergedByPushOp.Factory mergedByPushOpFactory, PatchSetUtil psUtil, ReplacePatchSetSender.Factory replacePatchSetFactory, ProjectCache projectCache, @SendEmailExecutor ExecutorService sendEmailExecutor, @Assisted ProjectControl projectControl, @Assisted Branch.NameKey dest, @Assisted boolean checkMergedInto, @Assisted(value="priorPatchSetId") PatchSet.Id priorPatchSetId, @Assisted(value="priorCommitId") ObjectId priorCommitId, @Assisted(value="patchSetId") PatchSet.Id patchSetId, @Assisted(value="commitId") ObjectId commitId, @Assisted PatchSetInfo info, @Assisted List<String> groups, @Assisted @Nullable ReceiveCommits.MagicBranchInput magicBranch, @Assisted @Nullable PushCertificate pushCertificate) {
        this.accountResolver = accountResolver;
        this.approvalCopier = approvalCopier;
        this.approvalsUtil = approvalsUtil;
        this.changeDataFactory = changeDataFactory;
        this.changeKindCache = changeKindCache;
        this.cmUtil = cmUtil;
        this.commentsUtil = commentsUtil;
        this.emailCommentsFactory = emailCommentsFactory;
        this.revisionCreated = revisionCreated;
        this.commentAdded = commentAdded;
        this.mergedByPushOpFactory = mergedByPushOpFactory;
        this.psUtil = psUtil;
        this.replacePatchSetFactory = replacePatchSetFactory;
        this.projectCache = projectCache;
        this.sendEmailExecutor = sendEmailExecutor;
        this.projectControl = projectControl;
        this.dest = dest;
        this.checkMergedInto = checkMergedInto;
        this.priorPatchSetId = priorPatchSetId;
        this.priorCommitId = priorCommitId.copy();
        this.patchSetId = patchSetId;
        this.commitId = commitId.copy();
        this.info = info;
        this.groups = groups;
        this.magicBranch = magicBranch;
        this.pushCertificate = pushCertificate;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws Exception {
        String mergedInto;
        this.commit = ctx.getRevWalk().parseCommit(this.commitId);
        ctx.getRevWalk().parseBody(this.commit);
        this.changeKind = this.changeKindCache.getChangeKind(this.projectControl.getProject().getNameKey(), ctx.getRevWalk(), ctx.getRepoView().getConfig(), this.priorCommitId, this.commitId);
        if (this.checkMergedInto && (mergedInto = ReplaceOp.findMergedInto(ctx, this.dest.get(), this.commit)) != null) {
            this.mergedByPushOp = this.mergedByPushOpFactory.create(this.requestScopePropagator, this.patchSetId, mergedInto);
        }
        this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.commitId, this.patchSetId.toRefName());
        ctx.addRefUpdate(this.cmd);
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException, PermissionBackendException {
        this.notes = ctx.getNotes();
        Change change = this.notes.getChange();
        if (change == null || change.getStatus().isClosed()) {
            this.rejectMessage = CHANGE_IS_CLOSED;
            return false;
        }
        if (this.groups.isEmpty()) {
            PatchSet prevPs = this.psUtil.current(ctx.getDb(), this.notes);
            this.groups = prevPs != null ? prevPs.getGroups() : ImmutableList.of();
        }
        ChangeUpdate update = ctx.getUpdate(this.patchSetId);
        update.setSubjectForCommit("Create patch set " + this.patchSetId.get());
        String reviewMessage = null;
        String psDescription = null;
        if (this.magicBranch != null) {
            this.recipients.add(this.magicBranch.getMailRecipients());
            reviewMessage = this.magicBranch.message;
            psDescription = this.magicBranch.message;
            this.approvals.putAll(this.magicBranch.labels);
            Set<String> hashtags = this.magicBranch.hashtags;
            if (hashtags != null && !hashtags.isEmpty()) {
                hashtags.addAll(this.notes.getHashtags());
                update.setHashtags(hashtags);
            }
            if (this.magicBranch.topic != null && !this.magicBranch.topic.equals(ctx.getChange().getTopic())) {
                update.setTopic(this.magicBranch.topic);
            }
            if (this.magicBranch.removePrivate) {
                change.setPrivate(false);
                update.setPrivate(false);
            } else if (this.magicBranch.isPrivate) {
                change.setPrivate(true);
                update.setPrivate(true);
            }
            if (this.magicBranch.ready) {
                change.setWorkInProgress(false);
                change.setReviewStarted(true);
                update.setWorkInProgress(false);
            } else if (this.magicBranch.workInProgress) {
                change.setWorkInProgress(true);
                update.setWorkInProgress(true);
            }
            if (this.shouldPublishComments()) {
                boolean workInProgress = change.isWorkInProgress();
                if (this.magicBranch != null && this.magicBranch.workInProgress) {
                    workInProgress = true;
                }
                this.comments = this.publishComments(ctx, workInProgress);
            }
        }
        this.newPatchSet = this.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), update, this.patchSetId, this.commitId, this.groups, this.pushCertificate != null ? this.pushCertificate.toTextWithSignature() : null, psDescription);
        update.setPsDescription(psDescription);
        this.recipients.add(MailUtil.getRecipientsFromFooters(this.accountResolver, this.commit.getFooterLines()));
        this.recipients.remove(ctx.getAccountId());
        ChangeData cd = this.changeDataFactory.create(ctx.getDb(), ctx.getNotes());
        MailUtil.MailRecipients oldRecipients = MailUtil.getRecipientsFromReviewers(cd.reviewers());
        Iterable<PatchSetApproval> newApprovals = this.approvalsUtil.addApprovalsForNewPatchSet(ctx.getDb(), update, this.projectControl.getProjectState().getLabelTypes(), this.newPatchSet, ctx.getUser(), this.approvals);
        this.approvalCopier.copyInReviewDb(ctx.getDb(), ctx.getNotes(), ctx.getUser(), this.newPatchSet, ctx.getRevWalk(), ctx.getRepoView().getConfig(), newApprovals);
        this.approvalsUtil.addReviewers(ctx.getDb(), update, this.projectControl.getProjectState().getLabelTypes(), change, this.newPatchSet, this.info, this.recipients.getReviewers(), oldRecipients.getAll());
        if (this.magicBranch != null && !this.magicBranch.labels.isEmpty()) {
            update.putReviewer(ctx.getAccountId(), ReviewerStateInternal.REVIEWER);
        }
        this.recipients.add(oldRecipients);
        this.msg = this.createChangeMessage(ctx, reviewMessage);
        this.cmUtil.addChangeMessage(ctx.getDb(), update, this.msg);
        if (this.mergedByPushOp == null) {
            this.resetChange(ctx);
        } else {
            this.mergedByPushOp.setPatchSetProvider(Providers.of(this.newPatchSet)).updateChange(ctx);
        }
        return true;
    }

    private ChangeMessage createChangeMessage(ChangeContext ctx, String reviewMessage) throws OrmException, IOException {
        String approvalMessage = ApprovalsUtil.renderMessageWithApprovals(this.patchSetId.get(), this.approvals, this.scanLabels(ctx, this.approvals));
        String kindMessage = this.changeKindMessage(this.changeKind);
        StringBuilder message = new StringBuilder(approvalMessage);
        if (!Strings.isNullOrEmpty(kindMessage)) {
            message.append(kindMessage);
        } else {
            message.append('.');
        }
        if (this.comments.size() == 1) {
            message.append("\n\n(1 comment)");
        } else if (this.comments.size() > 1) {
            message.append(String.format("\n\n(%d comments)", this.comments.size()));
        }
        if (!Strings.isNullOrEmpty(reviewMessage)) {
            message.append("\n\n").append(reviewMessage);
        }
        boolean workInProgress = ctx.getChange().isWorkInProgress();
        if (this.magicBranch != null && this.magicBranch.workInProgress) {
            workInProgress = true;
        }
        return ChangeMessagesUtil.newMessage(this.patchSetId, ctx.getUser(), ctx.getWhen(), message.toString(), ChangeMessagesUtil.uploadedPatchSetTag(workInProgress));
    }

    private String changeKindMessage(ChangeKind changeKind) {
        switch (changeKind) {
            case MERGE_FIRST_PARENT_UPDATE: 
            case TRIVIAL_REBASE: 
            case NO_CHANGE: {
                return ": Patch Set " + this.priorPatchSetId.get() + " was rebased.";
            }
            case NO_CODE_CHANGE: {
                return ": Commit message was updated.";
            }
        }
        return null;
    }

    private Map<String, PatchSetApproval> scanLabels(ChangeContext ctx, Map<String, Short> approvals) throws OrmException, IOException {
        HashMap<String, PatchSetApproval> current = new HashMap<String, PatchSetApproval>();
        if (!approvals.isEmpty()) {
            for (PatchSetApproval a : this.approvalsUtil.byPatchSetUser(ctx.getDb(), ctx.getNotes(), ctx.getUser(), this.priorPatchSetId, ctx.getAccountId(), ctx.getRevWalk(), ctx.getRepoView().getConfig())) {
                LabelType lt;
                if (a.isLegacySubmit() || (lt = this.projectControl.getProjectState().getLabelTypes().byLabel(a.getLabelId())) == null) continue;
                current.put(lt.getName(), a);
            }
        }
        return current;
    }

    private void resetChange(ChangeContext ctx) {
        Change change = ctx.getChange();
        if (!change.currentPatchSetId().equals(this.priorPatchSetId)) {
            return;
        }
        if (this.magicBranch != null && this.magicBranch.topic != null) {
            change.setTopic(this.magicBranch.topic);
        }
        change.setStatus(Change.Status.NEW);
        change.setCurrentPatchSet(this.info);
        List<String> idList = this.commit.getFooterLines(FooterConstants.CHANGE_ID);
        if (idList.isEmpty()) {
            change.setKey(new Change.Key("I" + this.commitId.name()));
        } else {
            change.setKey(new Change.Key(idList.get(idList.size() - 1).trim()));
        }
    }

    private List<Comment> publishComments(ChangeContext ctx, boolean workInProgress) throws OrmException {
        List<Comment> comments = this.commentsUtil.draftByChangeAuthor(ctx.getDb(), ctx.getNotes(), ctx.getUser().getAccountId());
        this.commentsUtil.publish(ctx, this.patchSetId, comments, ChangeMessagesUtil.uploadedPatchSetTag(workInProgress));
        return comments;
    }

    @Override
    public void postUpdate(Context ctx) throws Exception {
        NotifyHandling notify;
        if (this.changeKind != ChangeKind.TRIVIAL_REBASE) {
            ReplaceEmailTask e = new ReplaceEmailTask(ctx);
            if (this.requestScopePropagator != null) {
                Future<?> future = this.sendEmailExecutor.submit(this.requestScopePropagator.wrap(e));
            } else {
                e.run();
            }
        }
        NotifyHandling notifyHandling = notify = this.magicBranch != null ? this.magicBranch.getNotify(this.notes) : NotifyHandling.ALL;
        if (this.shouldPublishComments()) {
            this.emailCommentsFactory.create(notify, this.magicBranch != null ? this.magicBranch.getAccountsToNotify() : ImmutableListMultimap.of(), this.notes, this.newPatchSet, ctx.getUser().asIdentifiedUser(), this.msg, this.comments, this.msg.getMessage(), ImmutableList.of()).sendAsync();
        }
        this.revisionCreated.fire(this.notes.getChange(), this.newPatchSet, ctx.getAccount(), ctx.getWhen(), notify);
        try {
            this.fireCommentAddedEvent(ctx);
        }
        catch (Exception e) {
            log.warn("comment-added event invocation failed", e);
        }
        if (this.mergedByPushOp != null) {
            this.mergedByPushOp.postUpdate(ctx);
        }
    }

    private void fireCommentAddedEvent(Context ctx) throws IOException {
        if (this.approvals.isEmpty()) {
            return;
        }
        List<LabelType> labels = this.projectCache.checkedGet(ctx.getProject()).getLabelTypes(this.notes, ctx.getUser()).getLabelTypes();
        HashMap<String, Short> allApprovals = new HashMap<String, Short>();
        HashMap<String, Short> oldApprovals = new HashMap<String, Short>();
        for (LabelType labelType : labels) {
            allApprovals.put(labelType.getName(), (short)0);
            oldApprovals.put(labelType.getName(), null);
        }
        for (Map.Entry entry : this.approvals.entrySet()) {
            if ((Short)entry.getValue() == 0) continue;
            allApprovals.put((String)entry.getKey(), (Short)entry.getValue());
            oldApprovals.put((String)entry.getKey(), (short)0);
        }
        this.commentAdded.fire(this.notes.getChange(), this.newPatchSet, ctx.getAccount(), null, allApprovals, oldApprovals, ctx.getWhen());
    }

    public PatchSet getPatchSet() {
        return this.newPatchSet;
    }

    public Change getChange() {
        return this.notes.getChange();
    }

    public String getRejectMessage() {
        return this.rejectMessage;
    }

    public ReceiveCommand getCommand() {
        return this.cmd;
    }

    public ReplaceOp setRequestScopePropagator(RequestScopePropagator requestScopePropagator) {
        this.requestScopePropagator = requestScopePropagator;
        return this;
    }

    private static String findMergedInto(Context ctx, String first, RevCommit commit) {
        try {
            RevWalk rw = ctx.getRevWalk();
            Optional<ObjectId> firstId = ctx.getRepoView().getRef(first);
            if (firstId.isPresent() && rw.isMergedInto(commit, rw.parseCommit(firstId.get()))) {
                return first;
            }
            for (Map.Entry<String, ObjectId> e : ctx.getRepoView().getRefs("refs/heads/").entrySet()) {
                if (!rw.isMergedInto(commit, rw.parseCommit(e.getValue()))) continue;
                return "refs/heads/" + e.getKey();
            }
            return null;
        }
        catch (IOException e) {
            log.warn("Can't check for already submitted change", e);
            return null;
        }
    }

    private boolean shouldPublishComments() {
        return this.magicBranch != null && this.magicBranch.shouldPublishComments();
    }

    private class ReplaceEmailTask
    implements Runnable {
        private final Context ctx;

        private ReplaceEmailTask(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            try {
                ReplacePatchSetSender cm = ReplaceOp.this.replacePatchSetFactory.create(ReplaceOp.this.projectControl.getProject().getNameKey(), ReplaceOp.this.notes.getChangeId());
                cm.setFrom(this.ctx.getAccount().getId());
                cm.setPatchSet(ReplaceOp.this.newPatchSet, ReplaceOp.this.info);
                cm.setChangeMessage(ReplaceOp.this.msg.getMessage(), this.ctx.getWhen());
                if (ReplaceOp.this.magicBranch != null) {
                    cm.setNotify(ReplaceOp.this.magicBranch.getNotify(ReplaceOp.this.notes));
                    cm.setAccountsToNotify(ReplaceOp.this.magicBranch.getAccountsToNotify());
                }
                cm.addReviewers(ReplaceOp.this.recipients.getReviewers());
                cm.addExtraCC(ReplaceOp.this.recipients.getCcOnly());
                cm.send();
            }
            catch (Exception e) {
                log.error("Cannot send email for new patch set " + ReplaceOp.this.newPatchSet.getId(), e);
            }
        }

        public String toString() {
            return "send-email newpatchset";
        }
    }

    public static interface Factory {
        public ReplaceOp create(ProjectControl var1, Branch.NameKey var2, boolean var3, @Assisted(value="priorPatchSetId") PatchSet.Id var4, @Assisted(value="priorCommitId") ObjectId var5, @Assisted(value="patchSetId") PatchSet.Id var6, @Assisted(value="commitId") ObjectId var7, PatchSetInfo var8, List<String> var9, @Nullable ReceiveCommits.MagicBranchInput var10, @Nullable PushCertificate var11);
    }
}

