/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.util.RequestId;
import java.io.IOException;
import java.util.Queue;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestHelperOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(TestHelperOp.class);
    private final Change.Id changeId;
    private final Submit.TestSubmitInput input;
    private final RequestId submissionId;

    TestHelperOp(Change.Id changeId, SubmitStrategy.Arguments args) {
        this.changeId = changeId;
        this.input = (Submit.TestSubmitInput)args.submitInput;
        this.submissionId = args.submissionId;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws IOException {
        Queue<Boolean> q = this.input.generateLockFailures;
        if (q != null && !q.isEmpty() && q.remove().booleanValue()) {
            this.logDebug("Adding bogus ref update to trigger lock failure, via change {}", this.changeId);
            ctx.addRefUpdate(ObjectId.fromString("deadbeefdeadbeefdeadbeefdeadbeefdeadbeef"), ObjectId.zeroId(), "refs/test/" + this.getClass().getSimpleName());
        }
    }

    private void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.submissionId + msg, args);
        }
    }
}

