/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class Groups {
    public Optional<InternalGroup> getGroup(ReviewDb db, AccountGroup.Id groupId) throws OrmException, NoSuchGroupException {
        Optional<AccountGroup> accountGroup = Optional.ofNullable(db.accountGroups().get(groupId));
        if (!accountGroup.isPresent()) {
            return Optional.empty();
        }
        AccountGroup.UUID groupUuid = accountGroup.get().getGroupUUID();
        ImmutableSet members = this.getMembers(db, groupUuid).collect(ImmutableSet.toImmutableSet());
        ImmutableSet subgroups = this.getSubgroups(db, groupUuid).collect(ImmutableSet.toImmutableSet());
        return accountGroup.map(group -> InternalGroup.create(group, members, subgroups));
    }

    public Optional<InternalGroup> getGroup(ReviewDb db, AccountGroup.UUID groupUuid) throws OrmException, NoSuchGroupException {
        Optional<AccountGroup> accountGroup = Groups.getGroupFromReviewDb(db, groupUuid);
        if (!accountGroup.isPresent()) {
            return Optional.empty();
        }
        ImmutableSet members = this.getMembers(db, groupUuid).collect(ImmutableSet.toImmutableSet());
        ImmutableSet subgroups = this.getSubgroups(db, groupUuid).collect(ImmutableSet.toImmutableSet());
        return accountGroup.map(group -> InternalGroup.create(group, members, subgroups));
    }

    static AccountGroup getExistingGroupFromReviewDb(ReviewDb db, AccountGroup.UUID groupUuid) throws OrmException, NoSuchGroupException {
        Optional<AccountGroup> group = Groups.getGroupFromReviewDb(db, groupUuid);
        return group.orElseThrow(() -> new NoSuchGroupException(groupUuid));
    }

    private static Optional<AccountGroup> getGroupFromReviewDb(ReviewDb db, AccountGroup.UUID groupUuid) throws OrmException {
        List<AccountGroup> accountGroups = db.accountGroups().byUUID(groupUuid).toList();
        if (accountGroups.size() == 1) {
            return Optional.of(Iterables.getOnlyElement(accountGroups));
        }
        if (accountGroups.isEmpty()) {
            return Optional.empty();
        }
        throw new OrmDuplicateKeyException("Duplicate group UUID " + groupUuid);
    }

    public Stream<AccountGroup> getAll(ReviewDb db) throws OrmException {
        return Streams.stream(db.accountGroups().all());
    }

    public boolean isMember(ReviewDb db, AccountGroup.UUID groupUuid, Account.Id accountId) throws OrmException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        AccountGroupMember.Key key = new AccountGroupMember.Key(accountId, group.getId());
        return db.accountGroupMembers().get(key) != null;
    }

    public boolean isSubgroup(ReviewDb db, AccountGroup.UUID parentGroupUuid, AccountGroup.UUID subgroupUuid) throws OrmException, NoSuchGroupException {
        AccountGroup parentGroup = Groups.getExistingGroupFromReviewDb(db, parentGroupUuid);
        AccountGroupById.Key key = new AccountGroupById.Key(parentGroup.getId(), subgroupUuid);
        return db.accountGroupById().get(key) != null;
    }

    public Stream<Account.Id> getMembers(ReviewDb db, AccountGroup.UUID groupUuid) throws OrmException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        ResultSet<AccountGroupMember> accountGroupMembers = db.accountGroupMembers().byGroup(group.getId());
        return Streams.stream(accountGroupMembers).map(AccountGroupMember::getAccountId);
    }

    public Stream<AccountGroup.UUID> getSubgroups(ReviewDb db, AccountGroup.UUID groupUuid) throws OrmException, NoSuchGroupException {
        AccountGroup group = Groups.getExistingGroupFromReviewDb(db, groupUuid);
        ResultSet<AccountGroupById> accountGroupByIds = db.accountGroupById().byGroup(group.getId());
        return Streams.stream(accountGroupByIds).map(AccountGroupById::getIncludeUUID).distinct();
    }

    public static Stream<AccountGroup.Id> getGroupsWithMemberFromReviewDb(ReviewDb db, Account.Id accountId) throws OrmException {
        ResultSet<AccountGroupMember> accountGroupMembers = db.accountGroupMembers().byAccount(accountId);
        return Streams.stream(accountGroupMembers).map(AccountGroupMember::getAccountGroupId);
    }

    public static Stream<AccountGroup.Id> getParentGroupsFromReviewDb(ReviewDb db, AccountGroup.UUID subgroupUuid) throws OrmException {
        ResultSet<AccountGroupById> accountGroupByIds = db.accountGroupById().byIncludeUUID(subgroupUuid);
        return Streams.stream(accountGroupByIds).map(AccountGroupById::getGroupId);
    }

    public Stream<AccountGroup.UUID> getExternalGroups(ReviewDb db) throws OrmException {
        return Streams.stream(db.accountGroupById().all()).map(AccountGroupById::getIncludeUUID).distinct().filter(groupUuid -> !AccountGroup.isInternalGroup(groupUuid));
    }
}

