/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.extensions.common.LabelTypeInfo;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class ProjectJson {
    private final AllProjectsName allProjects;
    private final WebLinks webLinks;

    @Inject
    ProjectJson(AllProjectsName allProjectsName, WebLinks webLinks) {
        this.allProjects = allProjectsName;
        this.webLinks = webLinks;
    }

    public ProjectInfo format(ProjectState projectState) {
        ProjectInfo info = this.format(projectState.getProject());
        info.labels = new HashMap<String, LabelTypeInfo>();
        for (LabelType t : projectState.getLabelTypes().getLabelTypes()) {
            LabelTypeInfo labelInfo = new LabelTypeInfo();
            labelInfo.values = t.getValues().stream().collect(Collectors.toMap(LabelValue::formatValue, LabelValue::getText));
            labelInfo.defaultValue = t.getDefaultValue();
            info.labels.put(t.getName(), labelInfo);
        }
        return info;
    }

    public ProjectInfo format(Project p) {
        ProjectInfo info = new ProjectInfo();
        info.name = p.getName();
        Project.NameKey parentName = p.getParent(this.allProjects);
        info.parent = parentName != null ? parentName.get() : null;
        info.description = Strings.emptyToNull(p.getDescription());
        info.state = p.getState();
        info.id = Url.encode(info.name);
        List<WebLinkInfo> links = this.webLinks.getProjectLinks(p.getName());
        info.webLinks = links.isEmpty() ? null : links;
        return info;
    }
}

