/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.projects.DescriptionInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class PutDescription
implements RestModifyView<ProjectResource, DescriptionInput> {
    private final ProjectCache cache;
    private final MetaDataUpdate.Server updateFactory;

    @Inject
    PutDescription(ProjectCache cache, MetaDataUpdate.Server updateFactory) {
        this.cache = cache;
        this.updateFactory = updateFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response<String> apply(ProjectResource resource, DescriptionInput input) throws AuthException, ResourceConflictException, ResourceNotFoundException, IOException {
        if (input == null) {
            input = new DescriptionInput();
        }
        ProjectControl ctl = resource.getControl();
        IdentifiedUser user = ctl.getUser().asIdentifiedUser();
        if (!ctl.isOwner()) {
            throw new AuthException("not project owner");
        }
        try (MetaDataUpdate md = this.updateFactory.create(resource.getNameKey());){
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            project.setDescription(Strings.emptyToNull(input.description));
            String msg = MoreObjects.firstNonNull(Strings.emptyToNull(input.commitMessage), "Updated description.\n");
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            md.setAuthor(user);
            md.setMessage(msg);
            config.commit(md);
            this.cache.evict(ctl.getProject());
            md.getRepository().setGitwebDescription(project.getDescription());
            Response<String> response = Strings.isNullOrEmpty(project.getDescription()) ? Response.none() : Response.ok(project.getDescription());
            return response;
        }
        catch (RepositoryNotFoundException notFound) {
            throw new ResourceNotFoundException(resource.getName());
        }
        catch (ConfigInvalidException e) {
            throw new ResourceConflictException(String.format("invalid project.config: %s", e.getMessage()));
        }
    }
}

