/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.reviewdb.client.Project;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefUtil {
    private static final Logger log = LoggerFactory.getLogger(RefUtil.class);

    public static ObjectId parseBaseRevision(Repository repo, Project.NameKey projectName, String baseRevision) throws InvalidRevisionException {
        try {
            ObjectId revid = repo.resolve(baseRevision);
            if (revid == null) {
                throw new InvalidRevisionException();
            }
            return revid;
        }
        catch (IOException err) {
            log.error("Cannot resolve \"" + baseRevision + "\" in project \"" + projectName.get() + "\"", err);
            throw new InvalidRevisionException();
        }
        catch (RevisionSyntaxException err) {
            log.error("Invalid revision syntax \"" + baseRevision + "\"", err);
            throw new InvalidRevisionException();
        }
    }

    public static RevWalk verifyConnected(Repository repo, ObjectId revid) throws InvalidRevisionException {
        try {
            ObjectWalk rw = new ObjectWalk(repo);
            try {
                rw.markStart(rw.parseCommit(revid));
            }
            catch (IncorrectObjectTypeException err) {
                throw new InvalidRevisionException();
            }
            RefDatabase refDb = repo.getRefDatabase();
            Iterable<Ref> refs = Iterables.concat(refDb.getRefs("refs/heads/").values(), refDb.getRefs("refs/tags/").values());
            Ref rc = refDb.exactRef("refs/meta/config");
            if (rc != null) {
                refs = Iterables.concat(refs, Collections.singleton(rc));
            }
            for (Ref r : refs) {
                try {
                    rw.markUninteresting(rw.parseAny(r.getObjectId()));
                }
                catch (MissingObjectException err) {}
            }
            rw.checkConnectivity();
            return rw;
        }
        catch (IncorrectObjectTypeException | MissingObjectException err) {
            throw new InvalidRevisionException();
        }
        catch (IOException err) {
            log.error("Repository \"" + repo.getDirectory() + "\" may be corrupt; suggest running git fsck", err);
            throw new InvalidRevisionException();
        }
    }

    public static String getRefPrefix(String refName) {
        int i = refName.lastIndexOf(47);
        if (i > "refs/heads/".length() - 1) {
            return refName.substring(0, i);
        }
        return "refs/heads/";
    }

    public static String normalizeTagRef(String tag) throws BadRequestException {
        String result = tag;
        while (result.startsWith("/")) {
            result = result.substring(1);
        }
        if (result.startsWith("refs/") && !result.startsWith("refs/tags/")) {
            throw new BadRequestException("invalid tag name \"" + result + "\"");
        }
        if (!result.startsWith("refs/tags/")) {
            result = "refs/tags/" + result;
        }
        if (!Repository.isValidRefName(result)) {
            throw new BadRequestException("invalid tag name \"" + result + "\"");
        }
        return result;
    }

    static class InvalidRevisionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public static final String MESSAGE = "Invalid Revision";

        InvalidRevisionException() {
            super(MESSAGE);
        }
    }
}

