/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.LabelPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;

public class EqualsLabelPredicate
extends ChangeIndexPredicate {
    protected final ProjectCache projectCache;
    protected final PermissionBackend permissionBackend;
    protected final IdentifiedUser.GenericFactory userFactory;
    protected final Provider<ReviewDb> dbProvider;
    protected final String label;
    protected final int expVal;
    protected final Account.Id account;
    protected final AccountGroup.UUID group;

    public EqualsLabelPredicate(LabelPredicate.Args args, String label, int expVal, Account.Id account) {
        super(ChangeField.LABEL, ChangeField.formatLabel(label, expVal, account));
        this.permissionBackend = args.permissionBackend;
        this.projectCache = args.projectCache;
        this.userFactory = args.userFactory;
        this.dbProvider = args.dbProvider;
        this.group = args.group;
        this.label = label;
        this.expVal = expVal;
        this.account = account;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change c = object.change();
        if (c == null) {
            return false;
        }
        ProjectState project = this.projectCache.get(c.getDest().getParentKey());
        if (project == null) {
            return false;
        }
        LabelType labelType = EqualsLabelPredicate.type(project.getLabelTypes(), this.label);
        if (labelType == null) {
            return false;
        }
        boolean hasVote = false;
        for (PatchSetApproval p : object.currentApprovals()) {
            if (!labelType.matches(p)) continue;
            hasVote = true;
            if (!this.match(object, p.getValue(), p.getAccountId())) continue;
            return true;
        }
        return !hasVote && this.expVal == 0;
    }

    protected static LabelType type(LabelTypes types, String toFind) {
        if (types.byLabel(toFind) != null) {
            return types.byLabel(toFind);
        }
        for (LabelType lt : types.getLabelTypes()) {
            if (!toFind.equalsIgnoreCase(lt.getName())) continue;
            return lt;
        }
        return null;
    }

    protected boolean match(ChangeData cd, short value, Account.Id approver) {
        if (value != this.expVal) {
            return false;
        }
        if (this.account != null && !this.account.equals(approver)) {
            return false;
        }
        IdentifiedUser reviewer = this.userFactory.create(approver);
        if (this.group != null && !reviewer.getEffectiveGroups().contains(this.group)) {
            return false;
        }
        try {
            PermissionBackend.ForChange perm = ((PermissionBackend.WithUser)this.permissionBackend.user(reviewer).database(this.dbProvider)).change(cd);
            return perm.test(ChangePermission.READ);
        }
        catch (PermissionBackendException e) {
            return false;
        }
    }

    @Override
    public int getCost() {
        return 1 + (this.group == null ? 0 : 1);
    }
}

