/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.index.query.IsVisibleToPredicate;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.IndexUtils;
import com.google.gwtorm.server.OrmException;

public class GroupIsVisibleToPredicate
extends IsVisibleToPredicate<InternalGroup> {
    protected final GroupControl.GenericFactory groupControlFactory;
    protected final CurrentUser user;

    public GroupIsVisibleToPredicate(GroupControl.GenericFactory groupControlFactory, CurrentUser user) {
        super("visibleto", IndexUtils.describe(user));
        this.groupControlFactory = groupControlFactory;
        this.user = user;
    }

    @Override
    public boolean match(InternalGroup group) throws OrmException {
        try {
            return this.groupControlFactory.controlFor(this.user, group.getGroupUUID()).isVisible();
        }
        catch (NoSuchGroupException e) {
            return false;
        }
    }

    @Override
    public int getCost() {
        return 1;
    }
}

