/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.AclUtil;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_124;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_125
extends SchemaVersion {
    private static final String COMMIT_MSG = "Assign default permissions on user branches\n\nBy default each user should be able to read and update the own user\nbranch. Also the user should be able to approve and submit changes for\nthe own user branch. Assign default permissions for this and remove the\nold exclusive read protection from the user branches.\n";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final AllProjectsName allProjectsName;
    private final SystemGroupBackend systemGroupBackend;
    private final PersonIdent serverUser;

    @Inject
    Schema_125(Provider<Schema_124> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, AllProjectsName allProjectsName, SystemGroupBackend systemGroupBackend, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.allProjectsName = allProjectsName;
        this.systemGroupBackend = systemGroupBackend;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try (Repository git = this.repoManager.openRepository(this.allUsersName);
             MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git);){
            ProjectConfig config = ProjectConfig.read(md);
            config.getAccessSection("refs/users/*", true).remove(new Permission("read"));
            GroupReference registered = this.systemGroupBackend.getGroup(SystemGroupBackend.REGISTERED_USERS);
            AccessSection users = config.getAccessSection("refs/users/${shardeduserid}", true);
            AclUtil.grant(config, users, "read", true, registered);
            AclUtil.grant(config, users, "push", true, registered);
            AclUtil.grant(config, users, "submit", true, registered);
            for (LabelType lt : this.getLabelTypes(config)) {
                if (!"Code-Review".equals(lt.getName()) && !"Verified".equals(lt.getName())) continue;
                AclUtil.grant(config, users, lt, lt.getMin().getValue(), lt.getMax().getValue(), registered);
            }
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            md.setMessage(COMMIT_MSG);
            config.commit(md);
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }

    private Collection<LabelType> getLabelTypes(ProjectConfig config) throws IOException, ConfigInvalidException {
        HashMap<String, LabelType> labelTypes = new HashMap<String, LabelType>(config.getLabelSections());
        Project.NameKey parent = config.getProject().getParent(this.allProjectsName);
        while (parent != null) {
            Repository git = this.repoManager.openRepository(parent);
            Throwable throwable = null;
            try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, parent, git);){
                ProjectConfig parentConfig = ProjectConfig.read(md);
                for (LabelType lt : parentConfig.getLabelSections().values()) {
                    if (labelTypes.containsKey(lt.getName())) continue;
                    labelTypes.put(lt.getName(), lt);
                }
                parent = parentConfig.getProject().getParent(this.allProjectsName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (git == null) continue;
                Schema_125.$closeResource(throwable, git);
            }
        }
        return labelTypes.values();
    }
}

