/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.DynamicOptions;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.plugins.StartPluginListener;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.apache.sshd.server.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class SshPluginStarterCallback
implements StartPluginListener,
ReloadPluginListener {
    private static final Logger log = LoggerFactory.getLogger(SshPluginStarterCallback.class);
    private final DispatchCommandProvider root;
    private final DynamicMap<DynamicOptions.DynamicBean> dynamicBeans;

    @Inject
    SshPluginStarterCallback(@CommandName(value="") DispatchCommandProvider root, DynamicMap<DynamicOptions.DynamicBean> dynamicBeans) {
        this.root = root;
        this.dynamicBeans = dynamicBeans;
    }

    @Override
    public void onStartPlugin(Plugin plugin) {
        Provider<Command> cmd = this.load(plugin);
        if (cmd != null) {
            plugin.add(this.root.register(Commands.named(plugin.getName()), cmd));
        }
    }

    @Override
    public void onReloadPlugin(Plugin oldPlugin, Plugin newPlugin) {
        Provider<Command> cmd = this.load(newPlugin);
        if (cmd != null) {
            newPlugin.add(this.root.replace(Commands.named(newPlugin.getName()), cmd));
        }
    }

    private Provider<Command> load(Plugin plugin) {
        block3: {
            if (plugin.getSshInjector() != null) {
                Key<Command> key = Commands.key(plugin.getName());
                try {
                    return plugin.getSshInjector().getProvider(key);
                }
                catch (RuntimeException err) {
                    if (this.providesDynamicOptions(plugin)) break block3;
                    log.warn("Plugin {} did not define its top-level command nor any DynamicOptions", (Object)plugin.getName(), (Object)err);
                }
            }
        }
        return null;
    }

    private boolean providesDynamicOptions(Plugin plugin) {
        return this.dynamicBeans.plugins().contains(plugin.getName());
    }
}

