/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="set-project-parent", description="Change the project permissions are inherited from")
final class AdminSetParent
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(AdminSetParent.class);
    @Option(name="--parent", aliases={"-p"}, metaVar="NAME", usage="new parent project")
    private ProjectControl newParent;
    @Option(name="--children-of", metaVar="NAME", usage="parent project for which the child projects should be reparented")
    private ProjectControl oldParent;
    @Option(name="--exclude", metaVar="NAME", usage="child project of old parent project which should not be reparented")
    private List<ProjectControl> excludedChildren = new ArrayList<ProjectControl>();
    @Argument(index=0, required=false, multiValued=true, metaVar="NAME", usage="projects to modify")
    private List<ProjectControl> children = new ArrayList<ProjectControl>();
    @Inject
    private ProjectCache projectCache;
    @Inject
    private MetaDataUpdate.User metaDataUpdateFactory;
    @Inject
    private AllProjectsName allProjectsName;
    @Inject
    private ListChildProjects listChildProjects;
    private Project.NameKey newParentKey;

    AdminSetParent() {
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        if (this.oldParent == null && this.children.isEmpty()) {
            throw this.die("child projects have to be specified as arguments or the --children-of option has to be set");
        }
        if (this.oldParent == null && !this.excludedChildren.isEmpty()) {
            throw this.die("--exclude can only be used together with --children-of");
        }
        StringBuilder err = new StringBuilder();
        HashSet<Project.NameKey> grandParents = new HashSet<Project.NameKey>();
        grandParents.add(this.allProjectsName);
        if (this.newParent != null) {
            Object s;
            this.newParentKey = this.newParent.getProject().getNameKey();
            Project.NameKey gp = this.newParent.getProject().getParent();
            while (gp != null && grandParents.add(gp) && (s = this.projectCache.get(gp)) != null) {
                gp = ((ProjectState)s).getProject().getParent();
            }
        }
        ArrayList<Project.NameKey> childProjects = new ArrayList<Project.NameKey>();
        for (ProjectControl pc : this.children) {
            childProjects.add(pc.getProject().getNameKey());
        }
        if (this.oldParent != null) {
            try {
                childProjects.addAll(this.getChildrenForReparenting(this.oldParent));
            }
            catch (PermissionBackendException e) {
                throw new BaseCommand.Failure(1, "permissions unavailable", e);
            }
        }
        for (Project.NameKey nameKey : childProjects) {
            String name = nameKey.get();
            if (this.allProjectsName.equals(nameKey)) {
                err.append("error: Cannot set parent of '").append(name).append("'\n");
                continue;
            }
            if (grandParents.contains(nameKey) || nameKey.equals(this.newParentKey)) {
                err.append("error: Cycle exists between '").append(name).append("' and '").append(this.newParentKey != null ? this.newParentKey.get() : this.allProjectsName.get()).append("'\n");
                continue;
            }
            try (MetaDataUpdate md = this.metaDataUpdateFactory.create(nameKey);){
                ProjectConfig config = ProjectConfig.read(md);
                config.getProject().setParentName(this.newParentKey);
                md.setMessage("Inherit access from " + (this.newParentKey != null ? this.newParentKey.get() : this.allProjectsName.get()) + "\n");
                config.commit(md);
            }
            catch (RepositoryNotFoundException notFound) {
                err.append("error: Project ").append(name).append(" not found\n");
            }
            catch (IOException | ConfigInvalidException e) {
                String msg = "Cannot update project " + name;
                log.error(msg, e);
                err.append("error: ").append(msg).append("\n");
            }
            this.projectCache.evict(nameKey);
        }
        if (err.length() > 0) {
            while (err.charAt(err.length() - 1) == '\n') {
                err.setLength(err.length() - 1);
            }
            throw this.die(err.toString());
        }
    }

    private List<Project.NameKey> getChildrenForReparenting(ProjectControl parent) throws PermissionBackendException {
        ArrayList<Project.NameKey> childProjects = new ArrayList<Project.NameKey>();
        ArrayList<Project.NameKey> excluded = new ArrayList<Project.NameKey>(this.excludedChildren.size());
        for (ProjectControl excludedChild : this.excludedChildren) {
            excluded.add(excludedChild.getProject().getNameKey());
        }
        ArrayList<Project.NameKey> automaticallyExcluded = new ArrayList<Project.NameKey>(this.excludedChildren.size());
        if (this.newParentKey != null) {
            automaticallyExcluded.addAll(this.getAllParents(this.newParentKey));
        }
        for (ProjectInfo child : this.listChildProjects.apply(new ProjectResource(parent))) {
            Project.NameKey childName = new Project.NameKey(child.name);
            if (excluded.contains(childName)) continue;
            if (!automaticallyExcluded.contains(childName)) {
                childProjects.add(childName);
                continue;
            }
            this.stdout.println("Automatically excluded '" + childName + "' from reparenting because it is in the parent line of the new parent '" + this.newParentKey + "'.");
        }
        return childProjects;
    }

    private Set<Project.NameKey> getAllParents(Project.NameKey projectName) {
        ProjectState ps = this.projectCache.get(projectName);
        if (ps == null) {
            return Collections.emptySet();
        }
        return ps.parents().transform(s -> s.getNameKey()).toSet();
    }
}

