/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.PutName;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import org.kohsuke.args4j.Argument;

@CommandMetaData(name="rename-group", description="Rename an account group")
public class RenameGroupCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="GROUP", usage="name of the group to be renamed")
    private String groupName;
    @Argument(index=1, required=true, metaVar="NEWNAME", usage="new name of the group")
    private String newGroupName;
    @Inject
    private GroupsCollection groups;
    @Inject
    private PutName putName;

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            GroupResource rsrc = this.groups.parse(TopLevelResource.INSTANCE, IdString.fromDecoded(this.groupName));
            PutName.Input input = new PutName.Input();
            input.name = this.newGroupName;
            this.putName.apply(rsrc, input);
        }
        catch (RestApiException | OrmException | IOException e) {
            throw this.die(e);
        }
    }
}

