/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Supplier;
import com.google.gerrit.common.UserScopedEventListener;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.EventTypes;
import com.google.gerrit.server.events.ProjectNameKeySerializer;
import com.google.gerrit.server.events.SupplierSerializer;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.StreamCommandExecutor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresCapability(value="streamEvents")
@CommandMetaData(name="stream-events", description="Monitor events occurring in real time")
final class StreamEvents
extends BaseCommand {
    private static final Logger log = LoggerFactory.getLogger(StreamEvents.class);
    private static final int MAX_EVENTS = 128;
    private static final int BATCH_SIZE = 32;
    @Option(name="--subscribe", aliases={"-s"}, metaVar="SUBSCRIBE", usage="subscribe to specific stream-events")
    private List<String> subscribedToEvents = new ArrayList<String>();
    @Inject
    private IdentifiedUser currentUser;
    @Inject
    private DynamicSet<UserScopedEventListener> eventListeners;
    @Inject
    @StreamCommandExecutor
    private ScheduledThreadPoolExecutor pool;
    private final LinkedBlockingQueue<Event> queue = new LinkedBlockingQueue(128);
    private Gson gson;
    private RegistrationHandle eventListenerRegistration;
    private final WorkQueue.CancelableRunnable writer = new WorkQueue.CancelableRunnable(){

        @Override
        public void run() {
            StreamEvents.this.writeEvents();
        }

        @Override
        public void cancel() {
            StreamEvents.this.onExit(0);
        }

        public String toString() {
            return "Stream Events (" + StreamEvents.this.currentUser.getAccount().getUserName() + ")";
        }
    };
    private volatile boolean dropped;
    private final Object taskLock = new Object();
    private boolean done;
    private Future<?> task;
    private PrintWriter stdout;

    StreamEvents() {
    }

    @Override
    public void start(Environment env) throws IOException {
        try {
            this.parseCommandLine();
        }
        catch (BaseCommand.UnloggedFailure e) {
            String msg = e.getMessage();
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            this.err.write(msg.getBytes(StandardCharsets.UTF_8));
            this.err.flush();
            this.onExit(1);
            return;
        }
        this.stdout = StreamEvents.toPrintWriter(this.out);
        this.eventListenerRegistration = this.eventListeners.add(new UserScopedEventListener(){

            @Override
            public void onEvent(Event event) {
                if (StreamEvents.this.subscribedToEvents.isEmpty() || StreamEvents.this.subscribedToEvents.contains(event.getType())) {
                    StreamEvents.this.offer(event);
                }
            }

            @Override
            public CurrentUser getUser() {
                return StreamEvents.this.currentUser;
            }
        });
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Supplier.class), new SupplierSerializer()).registerTypeAdapter((Type)((Object)Project.NameKey.class), new ProjectNameKeySerializer()).create();
    }

    private void removeEventListenerRegistration() {
        if (this.eventListenerRegistration != null) {
            this.eventListenerRegistration.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onExit(int rc) {
        this.removeEventListenerRegistration();
        Object object = this.taskLock;
        synchronized (object) {
            this.done = true;
        }
        super.onExit(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        boolean exit;
        this.removeEventListenerRegistration();
        Object object = this.taskLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
                exit = false;
            } else {
                exit = !this.done;
            }
            this.done = true;
        }
        if (exit) {
            this.onExit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offer(Event event) {
        Object object = this.taskLock;
        synchronized (object) {
            if (!this.queue.offer(event)) {
                this.dropped = true;
            }
            if (this.task == null && !this.done) {
                this.task = this.pool.submit(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event poll() {
        Object object = this.taskLock;
        synchronized (object) {
            Event event = this.queue.poll();
            if (event == null) {
                this.task = null;
            }
            return event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEvents() {
        int processed;
        for (processed = 0; processed < 32; ++processed) {
            Event event;
            if (Thread.interrupted() || this.stdout.checkError()) {
                this.removeEventListenerRegistration();
                this.flush();
                this.onExit(0);
                return;
            }
            if (this.dropped) {
                this.write(new DroppedOutputEvent());
                this.dropped = false;
            }
            if ((event = this.poll()) == null) break;
            this.write(event);
        }
        this.flush();
        if (32 <= processed) {
            Object object = this.taskLock;
            synchronized (object) {
                this.task = this.pool.submit(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Object message) {
        String msg = null;
        try {
            msg = this.gson.toJson(message) + "\n";
        }
        catch (Exception e) {
            log.warn("Could not deserialize the msg: ", e);
        }
        if (msg != null) {
            PrintWriter printWriter = this.stdout;
            synchronized (printWriter) {
                this.stdout.print(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        PrintWriter printWriter = this.stdout;
        synchronized (printWriter) {
            this.stdout.flush();
        }
    }

    static {
        EventTypes.register("dropped-output", DroppedOutputEvent.class);
    }

    private static final class DroppedOutputEvent
    extends Event {
        private static final String TYPE = "dropped-output";

        DroppedOutputEvent() {
            super(TYPE);
        }
    }
}

