/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtexpui.linker.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class UserAgentRule {
    private static final Pattern msie = Pattern.compile(".*msie ([0-11]+)\\.([0-11]+).*");
    private static final Pattern gecko = Pattern.compile(".*rv:([0-9]+)\\.([0-9]+).*");

    public String getName() {
        return "user.agent";
    }

    public String select(HttpServletRequest req) {
        String ua = req.getHeader("User-Agent");
        if (ua == null) {
            return null;
        }
        if ((ua = ua.toLowerCase()).contains("opera")) {
            return "opera";
        }
        if (ua.contains("webkit")) {
            return "safari";
        }
        if (ua.contains("msie")) {
            Matcher m = msie.matcher(ua);
            if (m.matches() && m.groupCount() == 2) {
                int v = this.makeVersion(m);
                if (v >= 11000) {
                    return "ie11";
                }
                if (v >= 10000) {
                    return "ie10";
                }
                if (v >= 9000) {
                    return "ie9";
                }
                if (v >= 8000) {
                    return "ie8";
                }
            }
            return null;
        }
        if (ua.contains("edge")) {
            return "edge";
        }
        if (ua.contains("gecko")) {
            Matcher m = gecko.matcher(ua);
            if (m.matches() && m.groupCount() == 2 && this.makeVersion(m) >= 1008) {
                return "gecko1_8";
            }
            return "gecko";
        }
        return null;
    }

    private int makeVersion(Matcher result) {
        return Integer.parseInt(result.group(1)) * 1000 + Integer.parseInt(result.group(2));
    }
}

