/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import java.util.Objects;

public abstract class AbstractSoyFileSupplier
implements SoyFileSupplier {
    protected final SoyFileKind soyFileKind;
    protected final String filePath;

    public AbstractSoyFileSupplier(SoyFileKind soyFileKind, String filePath) {
        this.soyFileKind = soyFileKind;
        Preconditions.checkState(filePath != null && !filePath.isEmpty(), "Soy file path must be non-null and non-empty.");
        this.filePath = filePath;
    }

    @Override
    public SoyFileKind getSoyFileKind() {
        return this.soyFileKind;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractSoyFileSupplier && other.getClass() == this.getClass()) {
            AbstractSoyFileSupplier otherSupplier = (AbstractSoyFileSupplier)other;
            return this.filePath.equals(otherSupplier.filePath) && this.soyFileKind == otherSupplier.soyFileKind;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filePath, this.soyFileKind, this.getClass()});
    }
}

